/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco.itcoverage;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.jacoco.itcoverage.AbstractCoverageDecorator;
import org.sonar.plugins.jacoco.itcoverage.JaCoCoItMetrics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItCoverageDecorator
extends AbstractCoverageDecorator {
    @Override
    protected Metric getTargetMetric() {
        return JaCoCoItMetrics.IT_COVERAGE;
    }

    @DependsUpon
    public List<Metric> dependsUponMetrics() {
        return Arrays.asList(JaCoCoItMetrics.IT_LINES_TO_COVER, JaCoCoItMetrics.IT_UNCOVERED_LINES, JaCoCoItMetrics.IT_CONDITIONS_TO_COVER, JaCoCoItMetrics.IT_UNCOVERED_CONDITIONS);
    }

    @Override
    protected Double countCoveredElements(DecoratorContext context) {
        double uncoveredLines = MeasureUtils.getValue((Measure)context.getMeasure(JaCoCoItMetrics.IT_UNCOVERED_LINES), (Double)0.0);
        double lines = MeasureUtils.getValue((Measure)context.getMeasure(JaCoCoItMetrics.IT_LINES_TO_COVER), (Double)0.0);
        double uncoveredConditions = MeasureUtils.getValue((Measure)context.getMeasure(JaCoCoItMetrics.IT_UNCOVERED_CONDITIONS), (Double)0.0);
        double conditions = MeasureUtils.getValue((Measure)context.getMeasure(JaCoCoItMetrics.IT_CONDITIONS_TO_COVER), (Double)0.0);
        return lines + conditions - uncoveredConditions - uncoveredLines;
    }

    @Override
    protected Double countElements(DecoratorContext context) {
        double lines = MeasureUtils.getValue((Measure)context.getMeasure(JaCoCoItMetrics.IT_LINES_TO_COVER), (Double)0.0);
        double conditions = MeasureUtils.getValue((Measure)context.getMeasure(JaCoCoItMetrics.IT_CONDITIONS_TO_COVER), (Double)0.0);
        return lines + conditions;
    }
}

