/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco.itcoverage;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

public abstract class AbstractCoverageDecorator
implements Decorator {
    public boolean shouldExecuteOnProject(Project project) {
        return project.getAnalysisType().isDynamic(true);
    }

    @DependedUpon
    public Metric generatesCoverage() {
        return this.getTargetMetric();
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldDecorate(resource, context)) {
            this.saveLineCoverage(context);
        }
    }

    protected boolean shouldDecorate(Resource resource, DecoratorContext context) {
        return context.getMeasure(this.getTargetMetric()) == null && !ResourceUtils.isUnitTestClass((Resource)resource);
    }

    private void saveLineCoverage(DecoratorContext context) {
        Double elements = this.countElements(context);
        Double coveredElements = this.countCoveredElements(context);
        if (elements != null && elements > 0.0 && coveredElements != null) {
            context.saveMeasure(this.getTargetMetric(), Double.valueOf(this.calculateCoverage(coveredElements, elements)));
        }
    }

    private double calculateCoverage(Double coveredLines, Double lines) {
        return 100.0 * coveredLines / lines;
    }

    protected abstract Metric getTargetMetric();

    protected abstract Double countCoveredElements(DecoratorContext var1);

    protected abstract Double countElements(DecoratorContext var1);
}

