/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.core.analysis.ILines;
import org.jacoco.core.analysis.SourceFileCoverage;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.IStructureVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.instr.Analyzer;
import org.sonar.api.Plugins;
import org.sonar.api.batch.AbstractCoverageExtension;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.maven.DependsUponMavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.PropertiesBuilder;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoMavenPluginHandler;
import org.sonar.plugins.jacoco.JaCoCoUtils;

public class JaCoCoSensor
extends AbstractCoverageExtension
implements Sensor,
DependsUponMavenPlugin {
    private PropertiesBuilder<Integer, Integer> lineHitsBuilder = new PropertiesBuilder();
    private JaCoCoMavenPluginHandler handler;

    public JaCoCoSensor(Plugins plugins, JaCoCoMavenPluginHandler handler) {
        super(plugins);
        this.handler = handler;
    }

    public MavenPluginHandler getMavenPluginHandler(Project project) {
        if (project.getAnalysisType().equals((Object)Project.AnalysisType.DYNAMIC)) {
            return this.handler;
        }
        return null;
    }

    public void analyse(Project project, SensorContext context) {
        File buildOutputDir = project.getFileSystem().getBuildOutputDir();
        if (!buildOutputDir.exists()) {
            JaCoCoUtils.LOG.info("Can't find build output directory: {}. Skipping JaCoCo analysis.", (Object)buildOutputDir);
            return;
        }
        String path = this.getReportPath(project);
        File jacocoExecutionData = project.getFileSystem().resolvePath(path);
        try {
            this.readExecutionData(jacocoExecutionData, buildOutputDir, context);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
    }

    public void readExecutionData(File jacocoExecutionData, File buildOutputDir, SensorContext context) throws IOException {
        SessionInfoStore sessionInfoStore = new SessionInfoStore();
        ExecutionDataStore executionDataStore = new ExecutionDataStore();
        if (jacocoExecutionData == null || !jacocoExecutionData.exists() || !jacocoExecutionData.isFile()) {
            JaCoCoUtils.LOG.info("Can't find JaCoCo execution data : {}. Project coverage is set to 0%.", (Object)jacocoExecutionData);
        } else {
            JaCoCoUtils.LOG.info("Analysing {}", (Object)jacocoExecutionData);
            ExecutionDataReader reader = new ExecutionDataReader((InputStream)new FileInputStream(jacocoExecutionData));
            reader.setSessionInfoVisitor((ISessionInfoVisitor)sessionInfoStore);
            reader.setExecutionDataVisitor((IExecutionDataVisitor)executionDataStore);
            reader.read();
        }
        CoverageBuilder coverageBuilder = new CoverageBuilder(executionDataStore);
        Analyzer analyzer = new Analyzer((IStructureVisitor)coverageBuilder);
        analyzer.analyzeAll(buildOutputDir);
        for (SourceFileCoverage coverage : coverageBuilder.getSourceFiles()) {
            String fileName = StringUtils.substringBeforeLast((String)coverage.getName(), (String)".");
            String resourceName = StringUtils.replaceChars((String)(coverage.getPackageName() + "/" + fileName), (char)'/', (char)'.');
            JavaFile resource = new JavaFile(resourceName);
            this.analyzeClass(resource, (ICoverageNode)coverage, context);
        }
    }

    private void analyzeClass(JavaFile resource, ICoverageNode coverage, SensorContext context) {
        this.lineHitsBuilder.clear();
        ILines lines = coverage.getLines();
        block5: for (int lineId = lines.getFirstLine(); lineId <= lines.getLastLine(); ++lineId) {
            int fakeHits;
            switch (lines.getStatus(lineId)) {
                case 2: {
                    fakeHits = 1;
                    break;
                }
                case 1: 
                case 3: {
                    fakeHits = 0;
                    break;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    JaCoCoUtils.LOG.warn("Unknown status for line {} in {}", (Object)lineId, (Object)resource);
                    continue block5;
                }
            }
            this.lineHitsBuilder.add((Object)lineId, (Object)fakeHits);
        }
        this.saveMeasures(context, resource, lines, this.lineHitsBuilder.buildData());
    }

    protected String getReportPath(Project project) {
        return JaCoCoSensor.getPath(project);
    }

    public static String getPath(Project project) {
        return project.getConfiguration().getString("sonar.jacoco.reportPath", "target/jacoco.exec");
    }

    protected void saveMeasures(SensorContext context, JavaFile resource, ILines lines, String lineHitsData) {
        if (context.getResource((Resource)resource) != null) {
            context.saveMeasure((Resource)resource, CoreMetrics.LINES_TO_COVER, Double.valueOf(lines.getTotalCount()));
            context.saveMeasure((Resource)resource, CoreMetrics.UNCOVERED_LINES, Double.valueOf(lines.getMissedCount()));
            Measure lineHits = new Measure(CoreMetrics.COVERAGE_LINE_HITS_DATA).setData(lineHitsData);
            context.saveMeasure((Resource)resource, lineHits.setPersistenceMode(PersistenceMode.DATABASE));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

