/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.jacoco.core.runtime.AgentOptions;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.batch.maven.MavenPluginHandler;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoAgentDownloader;
import org.sonar.plugins.jacoco.JaCoCoSensor;
import org.sonar.plugins.jacoco.JaCoCoUtils;

public class JaCoCoMavenPluginHandler
implements MavenPluginHandler {
    private static final String ARG_LINE_PARAMETER = "argLine";
    private JaCoCoAgentDownloader downloader;
    private final String groupId;
    private final String artifactId;
    private final String version;

    public JaCoCoMavenPluginHandler(JaCoCoAgentDownloader downloader, Project project) {
        this.downloader = downloader;
        this.groupId = "org.apache.maven.plugins";
        this.artifactId = "maven-surefire-plugin";
        this.version = "2.4.3";
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isFixedVersion() {
        return false;
    }

    public String[] getGoals() {
        return new String[]{"test"};
    }

    public void configure(Project project, MavenPlugin plugin) {
        String excludes;
        String destfilePath = JaCoCoSensor.getPath(project);
        File destfile = project.getFileSystem().resolvePath(destfilePath);
        if (destfile.exists() && destfile.isFile()) {
            JaCoCoUtils.LOG.info("Deleting {}", (Object)destfile);
            if (!destfile.delete()) {
                throw new SonarException("Unable to delete " + destfile);
            }
        }
        Configuration configuration = project.getConfiguration();
        AgentOptions options = new AgentOptions();
        options.setDestfile(destfilePath);
        String includes = configuration.getString("sonar.jacoco.includes");
        if (StringUtils.isNotBlank((String)includes)) {
            options.setIncludes(includes);
        }
        if (StringUtils.isNotBlank((String)(excludes = configuration.getString("sonar.jacoco.excludes")))) {
            options.setExcludes(excludes);
        }
        String argument = options.getVMArgument(this.downloader.getAgentJarFile());
        String argLine = plugin.getParameter(ARG_LINE_PARAMETER);
        argLine = StringUtils.isBlank((String)argLine) ? argument : argument + " " + argLine;
        JaCoCoUtils.LOG.info("JVM options: {}", (Object)argLine);
        plugin.setParameter(ARG_LINE_PARAMETER, argLine);
    }
}

