/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchExtension;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.jacoco.JaCoCoUtils;

public class JaCoCoAgentDownloader
extends HttpDownloader
implements BatchExtension {
    private static File agentJarFile;
    private String host;

    public JaCoCoAgentDownloader(Configuration configuration) {
        this.host = StringUtils.chomp((String)configuration.getString("sonar.host.url", "http://localhost:9000"), (String)"/");
    }

    protected String getDownloadUrl() {
        return this.host + "/deploy/plugins/jacoco/agent-all-0.4.0.20100604151516.jar";
    }

    protected synchronized File getAgentJarFile() {
        if (agentJarFile == null) {
            agentJarFile = this.downloadAgent();
        }
        return agentJarFile;
    }

    protected File downloadAgent() {
        try {
            URI uri = new URI(this.getDownloadUrl());
            File agent = File.createTempFile("jacocoagent", ".jar");
            this.download(uri, agent);
            FileUtils.forceDeleteOnExit((File)agent);
            JaCoCoUtils.LOG.info("JaCoCo agent downloaded: {}", (Object)agent);
            return agent;
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new SonarException((Throwable)e);
        }
    }
}

