/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.types.FilterChain;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.entry.DataSource;
import org.codehaus.cargo.container.configuration.entry.ResourceSupport;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.property.LoggingLevel;
import org.codehaus.cargo.container.property.User;
import org.codehaus.cargo.container.spi.configuration.builder.AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalContainer;
import org.codehaus.cargo.container.tomcat.Tomcat5xEmbeddedLocalDeployer;
import org.codehaus.cargo.container.tomcat.TomcatCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCatalinaStandaloneLocalConfiguration
extends AbstractStandaloneLocalConfigurationWithXMLConfigurationBuilder
implements ResourceSupport {
    public AbstractCatalinaStandaloneLocalConfiguration(String dir) {
        super(dir);
        this.setProperty("cargo.servlet.users", "admin::manager");
        this.setProperty("cargo.rmi.port", "8205");
        this.setProperty("cargo.servlet.uriencoding", "ISO-8859-1");
        this.setProperty("cargo.tomcat.ajp.port", "8009");
        this.setProperty("cargo.tomcat.context.reloadable", "false");
        this.setProperty("cargo.tomcat.copywars", "true");
        this.setProperty("cargo.tomcat.webappsDirectory", "webapps");
    }

    protected void doConfigure(LocalContainer container) throws Exception {
        this.setupConfigurationDir();
        String confDir = this.getFileHandler().createDirectory(this.getHome(), "conf");
        FilterChain emptyFilterChain = this.createFilterChain();
        this.getFileHandler().createDirectory(this.getHome(), "temp");
        this.getFileHandler().createDirectory(this.getHome(), "logs");
        if (container instanceof InstalledLocalContainer) {
            FileConfig fc;
            InstalledLocalContainer installedContainer = (InstalledLocalContainer)container;
            String[] classPath = installedContainer.getExtraClasspath();
            if (classPath != null) {
                for (String path : classPath) {
                    fc = new FileConfig();
                    fc.setFile(path);
                    fc.setToDir("common/lib");
                    this.setFileProperty(fc);
                }
            }
            if ((classPath = installedContainer.getSharedClasspath()) != null) {
                for (String path : classPath) {
                    fc = new FileConfig();
                    fc.setFile(path);
                    fc.setToDir("shared/lib");
                    this.setFileProperty(fc);
                }
            }
            String sourceConf = this.getFileHandler().append(installedContainer.getHome(), "conf");
            String targetConf = this.getFileHandler().createDirectory(this.getHome(), "conf");
            this.getFileHandler().copyDirectory(sourceConf, targetConf);
            this.setupConfFiles(targetConf);
        } else if (container instanceof EmbeddedLocalContainer) {
            String webXml = this.getFileHandler().append(confDir, "web.xml");
            this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/" + container.getId() + "/web.xml", webXml, this.getFileHandler(), emptyFilterChain, "UTF-8");
        }
        String tomcatUsersXml = this.getFileHandler().append(confDir, "tomcat-users.xml");
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/tomcat/tomcat-users.xml", tomcatUsersXml, this.getFileHandler(), emptyFilterChain, "UTF-8");
        HashMap<String, String> replacements = new HashMap<String, String>(1);
        replacements.put("@tomcat.users@", this.getSecurityToken());
        this.getFileHandler().replaceInFile(tomcatUsersXml, replacements, "UTF-8");
        String loggingProperties = this.getFileHandler().append(confDir, "logging.properties");
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/tomcat/logging.properties", loggingProperties, this.getFileHandler(), emptyFilterChain, "UTF-8");
        replacements.clear();
        replacements.put("@catalina.logging.level@", this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        this.getFileHandler().replaceInFile(loggingProperties, replacements, "UTF-8");
        this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/tomcat/context.xml", this.getFileHandler().append(confDir, "context.xml"), this.getFileHandler(), this.createFilterChain(), "UTF-8");
        this.setupManager(container);
        this.setupWebApps(container);
    }

    protected String escapePath(String path) {
        String escapedPath = path;
        if (escapedPath.contains("\\")) {
            if (escapedPath.contains(":\\")) {
                escapedPath = '/' + escapedPath;
            }
            escapedPath = escapedPath.replace('\\', '/');
        }
        return escapedPath;
    }

    public void configureDataSources(LocalContainer container) {
        super.configureDataSources(container);
        this.setupTransactionManager();
    }

    protected abstract void setupTransactionManager();

    protected abstract void setupManager(LocalContainer var1);

    private void setupWebApps(LocalContainer container) {
        try {
            if (container instanceof EmbeddedLocalContainer) {
                Tomcat5xEmbeddedLocalDeployer deployer = new Tomcat5xEmbeddedLocalDeployer((EmbeddedLocalContainer)((Tomcat5xEmbeddedLocalContainer)container));
                deployer.deploy(this.getDeployables());
            } else {
                String appDir = this.getFileHandler().createDirectory(this.getHome(), this.getPropertyValue("cargo.tomcat.webappsDirectory"));
                TomcatCopyingInstalledLocalDeployer deployer = new TomcatCopyingInstalledLocalDeployer((InstalledLocalContainer)container);
                deployer.setShouldCopyWars(Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.copywars")));
                deployer.deploy(this.getDeployables());
                this.getResourceUtils().copyResource("org/codehaus/cargo/container/internal/resources/cargocpc.war", this.getFileHandler().append(appDir, "cargocpc.war"), this.getFileHandler());
            }
        }
        catch (Exception e) {
            throw new ContainerException("Failed to create a " + container.getName() + " container configuration", (Throwable)e);
        }
    }

    protected String getTomcatLoggingLevel(String cargoLoggingLevel) {
        String level = LoggingLevel.LOW.equalsLevel(cargoLoggingLevel) ? "1" : (LoggingLevel.MEDIUM.equalsLevel(cargoLoggingLevel) ? "2" : "4");
        return level;
    }

    protected String createTomcatWebappsToken() {
        StringBuilder webappTokenValue = new StringBuilder(" ");
        boolean copyWars = Boolean.parseBoolean(this.getPropertyValue("cargo.tomcat.copywars"));
        for (Deployable deployable : this.getDeployables()) {
            if (deployable.getType() != DeployableType.WAR) {
                throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
            }
            if (copyWars || TomcatUtils.containsContextFile(deployable)) continue;
            webappTokenValue.append(this.createContextToken((WAR)deployable));
        }
        return webappTokenValue.toString();
    }

    protected String createContextToken(WAR deployable) {
        StringBuilder contextTokenValue = new StringBuilder();
        contextTokenValue.append("<Context");
        contextTokenValue.append(" path=\"");
        if (!"".equals(deployable.getContext()) && !"/".equals(deployable.getContext())) {
            contextTokenValue.append("/" + deployable.getContext());
        }
        contextTokenValue.append("\"");
        contextTokenValue.append(" docBase=\"");
        contextTokenValue.append(new File(deployable.getFile()).getAbsolutePath());
        contextTokenValue.append("\"");
        contextTokenValue.append(" debug=\"");
        contextTokenValue.append(this.getTomcatLoggingLevel(this.getPropertyValue("cargo.logging")));
        contextTokenValue.append("\"");
        contextTokenValue.append(" reloadable=\"");
        contextTokenValue.append(this.getPropertyValue("cargo.tomcat.context.reloadable"));
        contextTokenValue.append("\"");
        contextTokenValue.append(">");
        contextTokenValue.append("</Context>");
        return contextTokenValue.toString();
    }

    public String toString() {
        return "Catalina Standalone Configuration";
    }

    protected String getSecurityToken() {
        StringBuilder token = new StringBuilder("");
        if (this.getPropertyValue("cargo.servlet.users") != null) {
            StringBuilder usersToken = new StringBuilder("");
            HashSet<String> rolesSet = new HashSet<String>();
            for (User user : User.parseUsers((String)this.getPropertyValue("cargo.servlet.users"))) {
                usersToken.append("<user ");
                usersToken.append("name=\"" + user.getName() + "\" ");
                usersToken.append("password=\"" + user.getPassword() + "\" ");
                usersToken.append("roles=\"");
                Iterator roles = user.getRoles().iterator();
                while (roles.hasNext()) {
                    String role = (String)roles.next();
                    usersToken.append(role);
                    if (roles.hasNext()) {
                        usersToken.append(',');
                    }
                    rolesSet.add(role);
                }
                usersToken.append("\"/>\n  ");
            }
            StringBuilder rolesToken = new StringBuilder("");
            for (String role : rolesSet) {
                rolesToken.append("<role rolename=\"" + role + "\"/>\n  ");
            }
            token.append((CharSequence)rolesToken).append((CharSequence)usersToken);
        }
        return token.toString();
    }

    protected abstract void setupConfFiles(String var1);

    protected String getXpathForDataSourcesParent() {
        return this.getXpathForResourcesParent();
    }

    public String getOrCreateDataSourceConfigurationFile(DataSource ds, LocalContainer container) {
        return this.getOrCreateResourceConfigurationFile(null, container);
    }

    protected Map<String, String> getNamespaces() {
        return Collections.emptyMap();
    }
}

