/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.spi.deployer.AbstractCopyingInstalledLocalDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatUtils;
import org.codehaus.cargo.util.Dom4JUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class TomcatCopyingInstalledLocalDeployer
extends AbstractCopyingInstalledLocalDeployer {
    private boolean shouldCopyWars = true;

    public TomcatCopyingInstalledLocalDeployer(InstalledLocalContainer container) {
        super(container);
    }

    public String getDeployableDir() {
        return this.getFileHandler().append(this.getContainer().getConfiguration().getHome(), this.getContainer().getConfiguration().getPropertyValue("cargo.tomcat.webappsDirectory"));
    }

    public void setShouldCopyWars(boolean shouldCopyWars) {
        this.shouldCopyWars = shouldCopyWars;
    }

    protected void doDeploy(String deployableDir, Deployable deployable) {
        if (DeployableType.WAR.equals((Object)deployable.getType())) {
            WAR war = (WAR)deployable;
            if (deployable.isExpanded()) {
                if (TomcatUtils.containsContextFile((Deployable)war)) {
                    String contextDir = this.getFileHandler().createDirectory(this.getContainer().getConfiguration().getHome(), "conf/Catalina/" + this.getContainer().getConfiguration().getPropertyValue("cargo.hostname"));
                    this.getLogger().info("Deploying WAR by creating Tomcat context XML file in [" + contextDir + "]...", ((Object)((Object)this)).getClass().getName());
                    Dom4JUtil xmlUtil = new Dom4JUtil(this.getFileHandler());
                    Document doc = xmlUtil.loadXmlFromFile(this.getFileHandler().append(war.getFile(), "META-INF/context.xml"));
                    Element context = doc.getRootElement();
                    if (context.attributeValue("docBase", "").length() <= 0) {
                        context.addAttribute("docBase", war.getFile());
                    }
                    xmlUtil.saveXml(doc, this.getFileHandler().append(contextDir, war.getContext() + ".xml"));
                } else if (this.shouldCopyWars) {
                    super.doDeploy(deployableDir, (Deployable)war);
                }
            } else if (TomcatUtils.containsContextFile((Deployable)war)) {
                super.doDeploy(deployableDir, (Deployable)war);
            } else if (this.shouldCopyWars) {
                super.doDeploy(deployableDir, (Deployable)war);
            }
        } else {
            super.doDeploy(deployableDir, deployable);
        }
    }

    public void undeploy(Deployable deployable) {
        if (!this.getContainer().getCapability().supportsDeployableType(deployable.getType())) {
            throw new ContainerException(this.getContainer().getName() + " doesn't support [" + deployable.getType().getType().toUpperCase() + "] archives. Got [" + deployable.getFile() + "]");
        }
        String deployableDir = this.getDeployableDir();
        try {
            String warLocation;
            if (deployable.getType() == DeployableType.WAR) {
                WAR war = (WAR)deployable;
                String context = war.getContext();
                this.getLogger().info("Undeploying context [" + context + "] from [" + deployableDir + "]...", ((Object)((Object)this)).getClass().getName());
                warLocation = war.isExpanded() ? this.getFileHandler().append(deployableDir, context) : this.getFileHandler().append(deployableDir, context + ".war");
                if (!this.getFileHandler().exists(warLocation)) {
                    throw new ContainerException("Failed to undeploy as there is no WAR at [" + warLocation + "]");
                }
            } else {
                throw new ContainerException("Only WAR undeployment is currently supported");
            }
            this.getLogger().info("Trying to delete WAR from [" + warLocation + "]...", ((Object)((Object)this)).getClass().getName());
            this.getFileHandler().delete(warLocation);
        }
        catch (Exception e) {
            throw new ContainerException("Failed to undeploy [" + deployable.getFile() + "] from [" + deployableDir + "]", (Throwable)e);
        }
    }

    protected String getDeployableName(Deployable deployable) {
        return super.getDeployableName(deployable).replace('/', '#');
    }
}

