/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.container.tomcat;

import java.io.IOException;
import org.codehaus.cargo.container.ContainerException;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.tomcat.internal.AbstractTomcatRemoteDeployer;
import org.codehaus.cargo.container.tomcat.internal.TomcatManagerException;

public class Tomcat7xRemoteDeployer
extends AbstractTomcatRemoteDeployer {
    public Tomcat7xRemoteDeployer(RemoteContainer container) {
        super(container);
        this.managerContext = this.managerContext + "/text";
    }

    protected void performUndeploy(Deployable deployable) throws TomcatManagerException, IOException {
        this.getTomcatManager().undeploy(this.getPath(deployable), this.getVersion(deployable));
    }

    protected String getPath(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
        }
        String path = "/" + ((WAR)deployable).getContext();
        int doubleHash = path.indexOf("##");
        if (doubleHash > 0) {
            path = path.substring(0, doubleHash);
        }
        return path;
    }

    protected String getVersion(Deployable deployable) {
        if (deployable.getType() != DeployableType.WAR) {
            throw new ContainerException("Only WAR archives are supported for deployment in Tomcat. Got [" + deployable.getFile() + "]");
        }
        String path = "/" + ((WAR)deployable).getContext();
        int doubleHash = path.indexOf("##");
        if (doubleHash > 0) {
            String version = path.substring(doubleHash + 2);
            return version;
        }
        return null;
    }
}

