/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml.impl;

import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsAGOccurs;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.xml.sax.SAXException;

public class XsAGOccursImpl
implements XsAGOccurs {
    private final XsObject owner;
    private int minOccurs = 1;
    private int maxOccurs = 1;

    public XsAGOccursImpl(XsObject pOwner) {
        this.owner = pOwner;
    }

    public void setMaxOccurs(String pMaxOccurs) {
        if ("unbounded".equals(pMaxOccurs)) {
            this.maxOccurs = -1;
        } else {
            try {
                this.maxOccurs = Integer.parseInt(pMaxOccurs);
                if (this.maxOccurs < 0) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid value for maxOccurs: " + pMaxOccurs + "; expected 'unbounded' or a nonnegative integer value.");
            }
        }
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMinOccurs(int pMinOccurs) {
        if (pMinOccurs < 0) {
            throw new IllegalArgumentException("Invalid value for minOccurs: " + pMinOccurs + "; expected a nonnegative integer value.");
        }
        this.minOccurs = pMinOccurs;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void validate() throws SAXException {
        if (this.maxOccurs != -1 && this.minOccurs > this.maxOccurs) {
            throw new LocSAXException("The 'minOccurs' attribute value (" + this.minOccurs + ") is greater than the 'maxOccurs' attribute value (" + this.maxOccurs + ")", this.owner.getLocator());
        }
    }
}

