/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.xs.xml.XsAnyURI;

public abstract class XsNamespaceList {
    public static final XsNamespaceList ANY = new XsNamespaceList(){

        public boolean isAny() {
            return true;
        }

        public boolean isOther() {
            return false;
        }

        public XsAnyURI[] getUris() {
            return null;
        }

        public String toString() {
            return "##any";
        }
    };

    public static XsNamespaceList valueOf(String pValue, XsAnyURI pTargetNamespace) {
        if ("##any".equals(pValue)) {
            return ANY;
        }
        if ("##other".equals(pValue)) {
            return new Other(pTargetNamespace);
        }
        return new Basic(pValue, pTargetNamespace);
    }

    public abstract boolean isAny();

    public abstract boolean isOther();

    public abstract XsAnyURI[] getUris();

    public static class Basic
    extends XsNamespaceList {
        private final XsAnyURI[] uris;
        private final String toStr;

        protected Basic(String pValue, XsAnyURI pTargetNamespace) {
            this.toStr = pValue;
            ArrayList<XsAnyURI> list = new ArrayList<XsAnyURI>();
            if (pTargetNamespace == null) {
                pTargetNamespace = new XsAnyURI("");
            }
            StringTokenizer st = new StringTokenizer(pValue);
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                XsAnyURI uri = "##targetNamespace".equals(s) ? pTargetNamespace : ("##local".equals(pTargetNamespace) ? new XsAnyURI("") : new XsAnyURI(s));
                if (list.contains(uri)) continue;
                list.add(uri);
            }
            this.uris = list.toArray(new XsAnyURI[list.size()]);
        }

        public boolean isAny() {
            return false;
        }

        public boolean isOther() {
            return false;
        }

        public XsAnyURI[] getUris() {
            return this.uris;
        }

        public String toString() {
            return this.toStr;
        }

        public int hashCode() {
            XsAnyURI[] uris = this.getUris();
            int hash = uris.length;
            for (int i = 0; i < uris.length; ++i) {
                hash += uris[i].hashCode();
            }
            return hash;
        }

        public boolean equals(Object pOther) {
            return pOther != null && pOther instanceof Basic && Arrays.equals(this.getUris(), ((Basic)pOther).getUris());
        }
    }

    public static class Other
    extends XsNamespaceList {
        private final XsAnyURI[] uris;

        protected Other(XsAnyURI pTargetNamespace) {
            if (pTargetNamespace == null) {
                pTargetNamespace = new XsAnyURI("");
            }
            this.uris = new XsAnyURI[]{pTargetNamespace};
        }

        public boolean isAny() {
            return false;
        }

        public boolean isOther() {
            return true;
        }

        public XsAnyURI[] getUris() {
            return this.uris;
        }

        public String toString() {
            return "##other";
        }

        public int hashCode() {
            return this.getUris()[0].hashCode();
        }

        public boolean equals(Object pOther) {
            return pOther != null && pOther instanceof Other && this.getUris()[0].equals(((Other)pOther).getUris()[0]);
        }
    }
}

