/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSModelGroup;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSObjectFactory;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSSchema;
import org.apache.ws.jaxme.xs.XSSimpleContentType;
import org.apache.ws.jaxme.xs.XSSimpleType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.impl.XSAttributeGroupImpl;
import org.apache.ws.jaxme.xs.impl.XSOpenAttrsImpl;
import org.apache.ws.jaxme.xs.impl.XSParticleImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.types.XSAnyType;
import org.apache.ws.jaxme.xs.xml.XsComplexContentType;
import org.apache.ws.jaxme.xs.xml.XsEAnnotation;
import org.apache.ws.jaxme.xs.xml.XsEChoice;
import org.apache.ws.jaxme.xs.xml.XsEComplexContent;
import org.apache.ws.jaxme.xs.xml.XsEList;
import org.apache.ws.jaxme.xs.xml.XsERestriction;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsESequence;
import org.apache.ws.jaxme.xs.xml.XsESimpleContent;
import org.apache.ws.jaxme.xs.xml.XsETopLevelSimpleType;
import org.apache.ws.jaxme.xs.xml.XsEUnion;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsSchemaHeader;
import org.apache.ws.jaxme.xs.xml.XsTAll;
import org.apache.ws.jaxme.xs.xml.XsTComplexRestrictionType;
import org.apache.ws.jaxme.xs.xml.XsTComplexType;
import org.apache.ws.jaxme.xs.xml.XsTExtensionType;
import org.apache.ws.jaxme.xs.xml.XsTGroupRef;
import org.apache.ws.jaxme.xs.xml.XsTLocalComplexType;
import org.apache.ws.jaxme.xs.xml.XsTLocalSimpleType;
import org.apache.ws.jaxme.xs.xml.XsTSimpleExtensionType;
import org.apache.ws.jaxme.xs.xml.XsTSimpleRestrictionType;
import org.apache.ws.jaxme.xs.xml.XsTSimpleType;
import org.apache.ws.jaxme.xs.xml.XsTTypeDefParticle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSTypeImpl
extends XSOpenAttrsImpl
implements XSType {
    private final boolean isSimple;
    private final XsQName name;
    private boolean isGlobal;
    private XSSimpleType simpleType;
    private XSComplexType complexType;
    private boolean isValidated;
    private final XsEAnnotation xsAnnotation;
    private XSAnnotation[] annotations;

    protected boolean isValidated() {
        return this.isValidated;
    }

    protected XSTypeImpl(XSObject pParent, XsETopLevelSimpleType pSimpleType) throws SAXException {
        super(pParent, pSimpleType);
        this.isSimple = true;
        XsNCName myName = pSimpleType.getName();
        if (myName == null) {
            throw new LocSAXException("Invalid simple type: Missing 'name' attribute.", pSimpleType.getLocator());
        }
        XsESchema schema = pSimpleType.getXsESchema();
        this.name = new XsQName(schema.getTargetNamespace(), myName.toString(), schema.getTargetNamespacePrefix());
        this.xsAnnotation = pSimpleType.getAnnotation();
    }

    protected XSTypeImpl(XSObject pParent, XsTLocalSimpleType pSimpleType) {
        super(pParent, pSimpleType);
        this.isSimple = true;
        this.name = null;
        this.xsAnnotation = pSimpleType == null ? null : pSimpleType.getAnnotation();
    }

    protected XSTypeImpl(XSObject pParent, XsTComplexType pComplexType) throws SAXException {
        super(pParent, pComplexType);
        this.isSimple = false;
        XsNCName myName = pComplexType.getName();
        if (myName == null) {
            throw new LocSAXException("Invalid complex type: Missing 'name' attribute.", pComplexType.getLocator());
        }
        XsESchema schema = pComplexType.getXsESchema();
        this.name = new XsQName(schema.getTargetNamespace(), myName.toString(), schema.getTargetNamespacePrefix());
        this.xsAnnotation = pComplexType.getAnnotation();
    }

    protected XSTypeImpl(XSObject pParent, XsTLocalComplexType pComplexType) {
        super(pParent, pComplexType);
        this.isSimple = false;
        this.name = null;
        this.xsAnnotation = pComplexType.getAnnotation();
    }

    protected XSTypeImpl(XSObject pParent, XsTSimpleRestrictionType pRestriction) throws SAXException {
        super(pParent, pRestriction);
        XsQName myName = pRestriction.getBase();
        if (myName == null) {
            throw new LocSAXException("Invalid 'restriction': Missing 'base' attribute.", pRestriction.getLocator());
        }
        XSType type = this.getXSSchema().getType(myName);
        if (type == null) {
            throw new LocSAXException("Invalid 'restriction': Unknown 'base' type " + myName, pRestriction.getLocator());
        }
        type.validate();
        if (type.isSimple()) {
            throw new LocSAXException("The 'base' type " + myName + " of 'simpleContent/restriction' is simple." + " It ought to be a complex type with simple content: ", pRestriction.getLocator());
        }
        XSComplexType myComplexType = type.getComplexType();
        if (!myComplexType.hasSimpleContent()) {
            throw new LocSAXException("The 'base' type " + myName + " of 'simpleContent/restriction' is complex," + " but doesn't have simple content: ", pRestriction.getLocator());
        }
        XSObjectFactory factory = pParent.getXSSchema().getXSObjectFactory();
        if (myComplexType.isExtension()) {
            XSSimpleType mySimpleType;
            XSType extendedType = myComplexType.getSimpleContent().getType();
            extendedType.validate();
            XSSimpleType extendedSimpleType = extendedType.getSimpleType();
            if (extendedSimpleType.isAtomic()) {
                mySimpleType = factory.newXSAtomicType((XSType)this, extendedType, pRestriction);
            } else if (extendedSimpleType.isList()) {
                mySimpleType = factory.newXSListType((XSType)this, extendedType, pRestriction);
            } else if (extendedSimpleType.isUnion()) {
                mySimpleType = factory.newXSUnionType((XSType)this, extendedType, pRestriction);
            } else {
                throw new LocSAXException("Unknown restriction type: " + extendedType, pRestriction.getLocator());
            }
            this.simpleType = mySimpleType;
        } else {
            XsTLocalSimpleType localSimpleType = pRestriction.getSimpleType();
            XSType restrictedType = localSimpleType != null ? factory.newXSType((XSObject)this, localSimpleType) : myComplexType.getSimpleContent().getType();
            restrictedType.validate();
            XSSimpleType restrictedSimpleType = restrictedType.getSimpleType();
            if (restrictedSimpleType.isAtomic()) {
                this.simpleType = factory.newXSAtomicType((XSType)this, restrictedType, pRestriction);
            } else if (restrictedSimpleType.isList()) {
                this.simpleType = factory.newXSListType((XSType)this, restrictedType, pRestriction);
            } else if (restrictedSimpleType.isUnion()) {
                this.simpleType = factory.newXSUnionType((XSType)this, restrictedType, pRestriction);
            }
        }
        this.name = null;
        this.isSimple = true;
        this.xsAnnotation = pRestriction.getAnnotation();
    }

    public XsQName getName() {
        return this.name;
    }

    public boolean isSimple() {
        return this.isSimple;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean pGlobal) {
        this.isGlobal = pGlobal;
    }

    public XSAnnotation[] getAnnotations() {
        return this.annotations;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validate() throws SAXException {
        if (this.isValidated()) {
            return;
        }
        this.isValidated = true;
        if (this.xsAnnotation == null) {
            this.annotations = new XSAnnotation[0];
        } else {
            XSAnnotation result = this.getXSSchema().getXSObjectFactory().newXSAnnotation(this, this.xsAnnotation);
            result.validate();
            this.annotations = new XSAnnotation[]{result};
        }
        if (this.isSimple()) {
            XSSimpleType mySimpleType;
            XsObject baseObject = this.getXsObject();
            if (baseObject instanceof XsTSimpleType) {
                XsTSimpleType myXsTSimpleType = (XsTSimpleType)baseObject;
                XsEList list = myXsTSimpleType.getList();
                if (list == null) {
                    XsEUnion union = myXsTSimpleType.getUnion();
                    if (union == null) {
                        XSType restrictedType;
                        Object baseType;
                        XsERestriction restriction = myXsTSimpleType.getRestriction();
                        if (restriction == null) {
                            throw new LocSAXException("Either of the 'list', 'union', or 'restriction' child elements must be set.", myXsTSimpleType.getLocator());
                        }
                        XsQName myName = restriction.getBase();
                        if (myName == null) {
                            baseType = restriction.getSimpleType();
                            if (baseType == null) {
                                throw new LocSAXException("Neither the 'base' attribute nor an inner 'simpleType' element are present", restriction.getLocator());
                            }
                            restrictedType = this.getXSSchema().getXSObjectFactory().newXSType((XSObject)this, (XsTLocalSimpleType)baseType);
                        } else {
                            restrictedType = this.getXSSchema().getType(myName);
                            if (restrictedType == null) {
                                throw new LocSAXException("Unknown base type: " + myName, restriction.getLocator());
                            }
                        }
                        restrictedType.validate();
                        if (!restrictedType.isSimple()) {
                            throw new LocSAXException("The restricted type " + myName + " is complex.", restriction.getLocator());
                        }
                        baseType = restrictedType.getSimpleType();
                        if (baseType.isAtomic()) {
                            mySimpleType = this.getXSSchema().getXSObjectFactory().newXSAtomicType((XSType)this, restrictedType, restriction);
                        } else if (baseType.isList()) {
                            mySimpleType = this.getXSSchema().getXSObjectFactory().newXSListType((XSType)this, restrictedType, restriction);
                        } else {
                            if (!baseType.isUnion()) throw new LocSAXException("Unknown restriction type: " + baseType, restriction.getLocator());
                            mySimpleType = this.getXSSchema().getXSObjectFactory().newXSUnionType((XSType)this, restrictedType, restriction);
                        }
                    } else {
                        mySimpleType = this.getXSSchema().getXSObjectFactory().newXSUnionType(this, union);
                    }
                } else {
                    mySimpleType = this.getXSSchema().getXSObjectFactory().newXSListType(this, list);
                }
            } else {
                mySimpleType = this.getSimpleType();
            }
            this.simpleType = mySimpleType;
            return;
        } else {
            this.validateComplexType();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateComplexType() throws SAXException, LocSAXException {
        void var1_16;
        XsTComplexType myXsTComplexType = (XsTComplexType)this.getXsObject();
        XsESimpleContent simpleContent = myXsTComplexType.getSimpleContent();
        if (simpleContent == null) {
            XsEComplexContent complexContent = myXsTComplexType.getComplexContent();
            if (complexContent == null) {
                XsTTypeDefParticle particle = myXsTComplexType.getTypeDefParticle();
                if (particle == null) {
                    XSSequenceComplexTypeImpl xSSequenceComplexTypeImpl = new XSSequenceComplexTypeImpl(this, myXsTComplexType);
                } else if (particle instanceof XsESequence) {
                    XSSequenceComplexTypeImpl xSSequenceComplexTypeImpl = new XSSequenceComplexTypeImpl(this, myXsTComplexType, (XsESequence)particle);
                } else if (particle instanceof XsEChoice) {
                    XSChoiceComplexTypeImpl xSChoiceComplexTypeImpl = new XSChoiceComplexTypeImpl(this, myXsTComplexType, (XsEChoice)particle);
                } else if (particle instanceof XsTAll) {
                    XSAllComplexTypeImpl xSAllComplexTypeImpl = new XSAllComplexTypeImpl(this, myXsTComplexType, (XsTAll)particle);
                } else {
                    if (!(particle instanceof XsTGroupRef)) throw new IllegalStateException("Invalid particle: " + particle.getClass().getName());
                    XsTGroupRef groupRef = (XsTGroupRef)particle;
                    XsQName myName = groupRef.getRef();
                    if (myName == null) {
                        throw new LocSAXException("Missing 'ref' attribute", groupRef.getLocator());
                    }
                    XSGroup group = this.getXSSchema().getGroup(myName);
                    if (group == null) {
                        throw new LocSAXException("Unknown group: " + myName, this.getLocator());
                    }
                    group.validate();
                    XSGroupComplexTypeImpl xSGroupComplexTypeImpl = new XSGroupComplexTypeImpl(this, myXsTComplexType, group, groupRef);
                }
            } else {
                XSComplexContentImpl complexContentImpl;
                XSComplexContentImpl xSComplexContentImpl = complexContentImpl = new XSComplexContentImpl(this, myXsTComplexType, complexContent);
            }
        } else {
            XSSimpleContentImpl simpleContentImpl;
            XSSimpleContentImpl xSSimpleContentImpl = simpleContentImpl = new XSSimpleContentImpl(this, myXsTComplexType, simpleContent);
        }
        this.complexType = var1_16;
        var1_16.validate();
    }

    public XSSimpleType getSimpleType() throws SAXException {
        this.validate();
        XSSimpleType result = this.simpleType;
        if (result == null) {
            throw new IllegalStateException("This is a complex type.");
        }
        return result;
    }

    public XSComplexType getComplexType() throws SAXException {
        this.validate();
        XSComplexType result = this.complexType;
        if (result == null) {
            if (this.getName() == null) {
                throw new IllegalStateException("This is a simple type.");
            }
            throw new IllegalStateException("The type " + this.getName() + " is simple.");
        }
        return result;
    }

    public boolean isBuiltin() {
        return false;
    }

    public XsSchemaHeader getSchemaHeader() {
        return this.getXsObject().getXsESchema();
    }

    public class XSGroupComplexTypeImpl
    extends XSBasicComplexTypeImpl {
        private final XSGroup group;

        public XSGroupComplexTypeImpl(XSType pOwner, XsTComplexType pType, XSGroup pGroup, XsTGroupRef pRef) throws SAXException {
            super(pOwner, pType);
            this.group = pGroup;
            XSParticleImpl particle = new XSParticleImpl(this.group);
            particle.setMinOccurs(pRef.getMinOccurs());
            particle.setMaxOccurs(pRef.getMaxOccurs());
            if (this.group.getParticles().length == 0) {
                this.setParticle(XsComplexContentType.EMPTY, particle);
            } else {
                this.setParticle(pType.isMixed() ? XsComplexContentType.MIXED : XsComplexContentType.ELEMENT_ONLY, particle);
            }
        }

        public boolean isAll() {
            return this.group.isAll();
        }

        public boolean isChoice() {
            return this.group.isChoice();
        }

        public boolean isSequence() {
            return this.group.isSequence();
        }
    }

    public class XSAllComplexTypeImpl
    extends XSBasicComplexTypeImpl {
        private final XsTAll all;

        public XSAllComplexTypeImpl(XSType pOwner, XsTComplexType pType, XsTAll pAll) throws SAXException {
            super(pOwner, pType);
            this.all = pAll;
            XSGroup group = pOwner.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)pOwner, this.all);
            group.validate();
            XSParticleImpl particle = new XSParticleImpl(group);
            particle.setMaxOccurs(pAll.getMaxOccurs());
            particle.setMinOccurs(pAll.getMinOccurs());
            if (group.getParticles().length == 0) {
                this.setParticle(XsComplexContentType.EMPTY, particle);
            } else {
                this.setParticle(pType.isMixed() ? XsComplexContentType.MIXED : XsComplexContentType.ELEMENT_ONLY, particle);
            }
        }

        public boolean isAll() {
            return true;
        }
    }

    public class XSChoiceComplexTypeImpl
    extends XSBasicComplexTypeImpl {
        private final XsEChoice choice;

        public XSChoiceComplexTypeImpl(XSType pOwner, XsTComplexType pType, XsEChoice pChoice) throws SAXException {
            super(pOwner, pType);
            this.choice = pChoice;
            XSGroup group = pOwner.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)pOwner, this.choice);
            group.validate();
            XSParticleImpl particle = new XSParticleImpl(group);
            particle.setMaxOccurs(pChoice.getMaxOccurs());
            particle.setMinOccurs(pChoice.getMinOccurs());
            if (group.getParticles().length == 0) {
                throw new LocSAXException("The complex type must not have an empty element group, as it is a choice.", this.choice.getLocator());
            }
            this.setParticle(pType.isMixed() ? XsComplexContentType.MIXED : XsComplexContentType.ELEMENT_ONLY, particle);
        }

        public boolean isChoice() {
            return true;
        }
    }

    public class XSSequenceComplexTypeImpl
    extends XSBasicComplexTypeImpl {
        private final XsESequence sequence;

        public XSSequenceComplexTypeImpl(XSType pOwner, XsTComplexType pType) throws SAXException {
            super(pOwner, pType);
            this.sequence = null;
            this.setParticle(pType.isMixed() ? XsComplexContentType.MIXED : XsComplexContentType.EMPTY, null);
        }

        public XSSequenceComplexTypeImpl(XSType pOwner, XsTComplexType pType, XsESequence pSequence) throws SAXException {
            super(pOwner, pType);
            this.sequence = pSequence;
            XSGroup group = pOwner.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)pOwner, this.sequence);
            group.validate();
            XSParticleImpl particle = new XSParticleImpl(group);
            particle.setMaxOccurs(pSequence.getMaxOccurs());
            particle.setMinOccurs(pSequence.getMinOccurs());
            if (group.getParticles().length == 0) {
                this.setParticle(XsComplexContentType.EMPTY, particle);
            } else {
                this.setParticle(pType.isMixed() ? XsComplexContentType.MIXED : XsComplexContentType.ELEMENT_ONLY, particle);
            }
        }

        public boolean isSequence() {
            return true;
        }
    }

    public abstract class XSBasicComplexTypeImpl
    extends XSComplexTypeImpl {
        private final XSAttributable[] attributes;
        private XSParticle particle;
        private XsComplexContentType contentType;

        public XSBasicComplexTypeImpl(XSType pOwner, XsTComplexType pType) throws SAXException {
            super(pOwner, pType);
            this.attributes = XSAttributeGroupImpl.getAttributes(XSTypeImpl.this, pType);
        }

        public void setParticle(XsComplexContentType pType, XSParticle pParticle) {
            this.contentType = pType;
            this.particle = pParticle;
        }

        public XSParticle getParticle() {
            return this.particle;
        }

        public XSAttributable[] getAttributes() {
            return this.attributes;
        }

        public XsComplexContentType getComplexContentType() {
            return this.contentType;
        }
    }

    public class XSComplexContentImpl
    extends XSComplexTypeImpl {
        private final XsEComplexContent complexContent;
        private final XSType owner;
        private boolean complexContentInitialized;
        private XSParticle complexContentParticle2;
        private XsComplexContentType complexContentType2;
        private XSAttributable[] attributes2;
        private XSType extendedType;

        protected XsEComplexContent getComplexContent() {
            return this.complexContent;
        }

        private int getMinOccursByParticle(XsTTypeDefParticle pParticle) throws SAXException {
            if (pParticle instanceof XsEChoice) {
                return ((XsEChoice)pParticle).getMinOccurs();
            }
            if (pParticle instanceof XsESequence) {
                return ((XsESequence)pParticle).getMinOccurs();
            }
            if (pParticle instanceof XsTAll) {
                return ((XsTAll)pParticle).getMinOccurs();
            }
            if (pParticle instanceof XsTGroupRef) {
                return ((XsTGroupRef)pParticle).getMinOccurs();
            }
            throw new IllegalStateException("Unknown TypeDefParticle type: " + pParticle.getClass().getName());
        }

        private int getMaxOccursByParticle(XsTTypeDefParticle pParticle) throws SAXException {
            if (pParticle instanceof XsEChoice) {
                return ((XsEChoice)pParticle).getMaxOccurs();
            }
            if (pParticle instanceof XsESequence) {
                return ((XsESequence)pParticle).getMaxOccurs();
            }
            if (pParticle instanceof XsTAll) {
                return ((XsTAll)pParticle).getMaxOccurs();
            }
            if (pParticle instanceof XsTGroupRef) {
                return ((XsTGroupRef)pParticle).getMaxOccurs();
            }
            throw new IllegalStateException("Unknown TypeDefParticle type: " + pParticle.getClass().getName());
        }

        protected XSGroup getGroupByParticle(XsTTypeDefParticle pParticle) throws SAXException {
            XSGroup result;
            XSType myOwner = this.getOwner();
            XSObjectFactory factory = myOwner.getXSSchema().getXSObjectFactory();
            if (pParticle == null) {
                return null;
            }
            if (pParticle instanceof XsEChoice) {
                XsEChoice choice = (XsEChoice)pParticle;
                result = factory.newXSGroup((XSObject)myOwner, choice);
            } else if (pParticle instanceof XsESequence) {
                XsESequence sequence = (XsESequence)pParticle;
                result = factory.newXSGroup((XSObject)myOwner, sequence);
            } else if (pParticle instanceof XsTAll) {
                XsTAll all = (XsTAll)pParticle;
                result = factory.newXSGroup((XSObject)myOwner, all);
            } else if (pParticle instanceof XsTGroupRef) {
                XsTGroupRef groupRef = (XsTGroupRef)pParticle;
                result = factory.newXSGroup((XSObject)myOwner, groupRef);
            } else {
                throw new IllegalStateException("Unknown TypeDefParticle type: " + pParticle.getClass().getName());
            }
            result.validate();
            return result;
        }

        protected XsComplexContentType getContentTypeByParticle(XsTTypeDefParticle pParticle, XSGroup pGroup) throws SAXException {
            if (pParticle == null) {
                return XsComplexContentType.EMPTY;
            }
            if (pParticle instanceof XsEChoice) {
                if (pGroup.getParticles().length == 0) {
                    XsEChoice choice = (XsEChoice)pParticle;
                    if (choice.getMinOccurs() == 0) {
                        return XsComplexContentType.EMPTY;
                    }
                    throw new LocSAXException("Invalid choice: Neither child elements, nor 'minOccurs'=0", choice.getLocator());
                }
            } else if (pParticle instanceof XsESequence) {
                if (pGroup.getParticles().length == 0) {
                    return XsComplexContentType.EMPTY;
                }
            } else if (pParticle instanceof XsTAll) {
                if (pGroup.getParticles().length == 0) {
                    return XsComplexContentType.EMPTY;
                }
            } else if (!(pParticle instanceof XsTGroupRef)) {
                throw new IllegalStateException("Unknown TypeDefParticle type: " + pParticle.getClass().getName());
            }
            boolean isMixed = this.complexContent.isMixed() == null ? ((XsTComplexType)XSTypeImpl.this.getXsObject()).isMixed() : this.complexContent.isMixed().booleanValue();
            return isMixed ? XsComplexContentType.MIXED : XsComplexContentType.ELEMENT_ONLY;
        }

        public XSComplexContentImpl(XSType pOwner, XsTComplexType pType, XsEComplexContent pComplexContent) throws SAXException {
            super(pOwner, pType);
            this.complexContent = pComplexContent;
            this.owner = pOwner;
        }

        public XSType getExtendedType() throws SAXException {
            this.initContent();
            if (this.extendedType == null) {
                super.getExtendedType();
            }
            return this.extendedType;
        }

        public boolean isExtension() throws SAXException {
            this.initContent();
            return this.extendedType != null;
        }

        public boolean hasComplexContent() {
            return true;
        }

        private void initContent() throws SAXException {
            if (this.complexContentInitialized) {
                return;
            }
            XsTExtensionType extension = this.complexContent.getExtension();
            if (extension == null) {
                XsTComplexRestrictionType restriction = this.complexContent.getRestriction();
                if (restriction == null) {
                    throw new LocSAXException("Neither of extension or restriction, aka restriction of the ur-type: Not implemented", this.complexContent.getLocator());
                }
                XsQName base = restriction.getBase();
                if (base == null) {
                    throw new LocSAXException("Invalid 'restriction': Missing 'base' attribute", XSTypeImpl.this.getLocator());
                }
                XSType type = XSTypeImpl.this.getXSSchema().getType(base);
                if (type == null) {
                    throw new LocSAXException("Invalid 'restriction': Unknown base type " + base, XSTypeImpl.this.getLocator());
                }
                if (type.isSimple()) {
                    throw new LocSAXException("Invalid 'restriction': The base type " + XSTypeImpl.this.getName() + " is simple.", XSTypeImpl.this.getLocator());
                }
                XsTTypeDefParticle particle = restriction.getTypeDefParticle();
                XSGroup group = this.getGroupByParticle(particle);
                this.complexContentParticle2 = group == null ? null : new XSParticleImpl(group);
                this.complexContentType2 = this.getContentTypeByParticle(particle, group);
                this.attributes2 = XSAttributeGroupImpl.getAttributes(XSTypeImpl.this, restriction);
                this.restrictedType = type;
            } else {
                XSGroup group;
                XsQName base = extension.getBase();
                if (base == null) {
                    throw new LocSAXException("Invalid 'extension': Missing 'base' attribute", XSTypeImpl.this.getLocator());
                }
                XSType type = XSTypeImpl.this.getXSSchema().getType(base);
                if (type == null) {
                    throw new LocSAXException("Invalid 'extension': Unknown base type " + base, XSTypeImpl.this.getLocator());
                }
                if (type.isSimple()) {
                    throw new LocSAXException("Invalid 'extension': The base type " + base + " is simple.", XSTypeImpl.this.getLocator());
                }
                XSComplexType extendedComplexType = type.getComplexType();
                if (extendedComplexType.hasSimpleContent()) {
                    throw new LocSAXException("Invalid 'extension': The base type " + base + " has simple content.", XSTypeImpl.this.getLocator());
                }
                XsTTypeDefParticle particle = extension.getTypeDefParticle();
                XsComplexContentType groupType = this.getContentTypeByParticle(particle, group = this.getGroupByParticle(particle));
                if (XsComplexContentType.EMPTY.equals(groupType)) {
                    if (type == XSAnyType.getInstance()) {
                        this.complexContentType2 = null;
                        this.complexContentParticle2 = null;
                    } else {
                        this.complexContentType2 = extendedComplexType.getComplexContentType();
                        this.complexContentParticle2 = extendedComplexType.getParticle();
                    }
                } else if (extendedComplexType.isEmpty()) {
                    this.complexContentType2 = groupType;
                    XSParticleImpl particleImpl = new XSParticleImpl(group);
                    particleImpl.setMinOccurs(this.getMinOccursByParticle(particle));
                    particleImpl.setMaxOccurs(this.getMaxOccursByParticle(particle));
                    this.complexContentParticle2 = particleImpl;
                } else {
                    ExtensionGroup sequenceGroup = new ExtensionGroup(this.owner, new XSParticle[]{extendedComplexType.getParticle(), new XSParticleImpl(group)});
                    this.complexContentParticle2 = new XSParticleImpl(sequenceGroup);
                    this.complexContentType2 = groupType;
                }
                XSAttributable[] inheritedAttributes = extendedComplexType.getAttributes();
                XSAttributable[] myAttributes = XSAttributeGroupImpl.getAttributes(XSTypeImpl.this, extension);
                this.attributes2 = new XSAttributable[inheritedAttributes.length + myAttributes.length];
                System.arraycopy(inheritedAttributes, 0, this.attributes2, 0, inheritedAttributes.length);
                System.arraycopy(myAttributes, 0, this.attributes2, inheritedAttributes.length, myAttributes.length);
                this.extendedType = type;
            }
            this.complexContentInitialized = true;
        }

        public XsComplexContentType getComplexContentType() throws SAXException {
            this.initContent();
            return this.complexContentType2;
        }

        public XSParticle getParticle() throws SAXException {
            this.initContent();
            return this.complexContentParticle2;
        }

        public XSAttributable[] getAttributes() throws SAXException {
            this.initContent();
            return this.attributes2;
        }

        private class ExtensionGroup
        implements XSGroup {
            private final XSObject parent;
            private final XSParticle[] particles;

            private ExtensionGroup(XSObject pParent, XSParticle[] pParticles) {
                this.parent = pParent;
                this.particles = pParticles;
            }

            public boolean isTopLevelObject() {
                return false;
            }

            public boolean isGlobal() {
                return false;
            }

            public XsQName getName() {
                return null;
            }

            public XSSchema getXSSchema() {
                return XSTypeImpl.this.getXSSchema();
            }

            public Locator getLocator() {
                return XSComplexContentImpl.this.getComplexContent().getLocator();
            }

            public void validate() throws SAXException {
            }

            public XSModelGroup.Compositor getCompositor() {
                return XSModelGroup.SEQUENCE;
            }

            public boolean isSequence() {
                return true;
            }

            public boolean isChoice() {
                return false;
            }

            public boolean isAll() {
                return false;
            }

            public XSParticle[] getParticles() {
                return this.particles;
            }

            public XSAnnotation[] getAnnotations() {
                return new XSAnnotation[0];
            }

            public void setGlobal(boolean pGlobal) {
                if (pGlobal) {
                    throw new IllegalStateException("An extensions model group cannot be made global.");
                }
            }

            public XSObject getParentObject() {
                return this.parent;
            }

            public Attributes getOpenAttributes() {
                return null;
            }
        }
    }

    public class XSSimpleContentImpl
    extends XSComplexTypeImpl {
        private final XsESimpleContent simpleContent;
        private final XSSimpleContentType simpleContentType;
        private final XSAttributable[] attributes;
        private final XSType extendedType;

        public boolean isElementOnly() {
            return false;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean isMixed() {
            return false;
        }

        public XSType getExtendedType() throws SAXException {
            if (this.extendedType == null) {
                super.getExtendedType();
            }
            return this.extendedType;
        }

        public boolean isExtension() throws SAXException {
            return this.extendedType != null;
        }

        public XSSimpleContentImpl(XSType pOwner, XsTComplexType pType, XsESimpleContent pSimpleContent) throws SAXException {
            super(pOwner, pType);
            this.simpleContent = pSimpleContent;
            XsTSimpleExtensionType extension = this.simpleContent.getExtension();
            if (extension == null) {
                XsTSimpleRestrictionType restriction = this.simpleContent.getRestriction();
                if (restriction == null) {
                    throw new LocSAXException("Invalid 'simpleContent', neither of the 'extension' or 'restriction' child elements are present.", this.simpleContent.getLocator());
                }
                XsQName restrictedTypesName = restriction.getBase();
                if (restrictedTypesName == null) {
                    throw new LocSAXException("Invalid 'restriction': Missing 'base' attribute.", restriction.getLocator());
                }
                this.restrictedType = XSTypeImpl.this.getXSSchema().getType(restrictedTypesName);
                if (this.restrictedType == null) {
                    throw new LocSAXException("Invalid 'restriction': The base type " + restrictedTypesName + " is unknown.", restriction.getLocator());
                }
                this.restrictedType.validate();
                this.extendedType = null;
                XSObjectFactory factory = pOwner.getXSSchema().getXSObjectFactory();
                XSType contentType = factory.newXSType((XSObject)pOwner, restriction);
                this.simpleContentType = factory.newXSSimpleContentType(pOwner, contentType, restriction);
                this.attributes = XSAttributeGroupImpl.getAttributes(XSTypeImpl.this, restriction);
            } else {
                XSAttributable[] inheritedAttributes;
                XsQName extendedTypesName = extension.getBase();
                if (extendedTypesName == null) {
                    throw new LocSAXException("Invalid 'extension': Missing 'base' attribute.", extension.getLocator());
                }
                this.extendedType = XSTypeImpl.this.getXSSchema().getType(extendedTypesName);
                if (this.extendedType == null) {
                    throw new LocSAXException("Invalid 'extension': Unknown 'base' type " + extendedTypesName, extension.getLocator());
                }
                this.extendedType.validate();
                this.restrictedType = null;
                if (this.extendedType.isSimple()) {
                    this.simpleContentType = this.getOwner().getXSSchema().getXSObjectFactory().newXSSimpleContentType(pOwner, this.extendedType, extension);
                    inheritedAttributes = new XSAttributable[]{};
                } else {
                    XSComplexType myComplexType = this.extendedType.getComplexType();
                    if (!myComplexType.hasSimpleContent()) {
                        throw new LocSAXException("Invalid 'extension': The base type " + extendedTypesName + " is neither a simple type nor a complex type with simple content.", extension.getLocator());
                    }
                    this.simpleContentType = myComplexType.getSimpleContent();
                    inheritedAttributes = myComplexType.getAttributes();
                }
                XSAttributable[] myAttributes = XSAttributeGroupImpl.getAttributes(XSTypeImpl.this, extension);
                this.attributes = new XSAttributable[inheritedAttributes.length + myAttributes.length];
                System.arraycopy(inheritedAttributes, 0, this.attributes, 0, inheritedAttributes.length);
                System.arraycopy(myAttributes, 0, this.attributes, inheritedAttributes.length, myAttributes.length);
            }
        }

        public boolean hasSimpleContent() {
            return true;
        }

        public XSSimpleContentType getSimpleContent() {
            return this.simpleContentType;
        }

        public XSAttributable[] getAttributes() {
            return this.attributes;
        }

        public XSParticle getParticle() {
            throw new IllegalStateException("This complex type doesn't have a model group particle.");
        }

        public XsComplexContentType getComplexContentType() {
            throw new IllegalStateException("This complex type (" + this.getClass().getName() + ") doesn't have complex content.");
        }
    }

    public abstract class XSComplexTypeImpl
    implements XSComplexType {
        protected final XSType owner;
        private final XsTComplexType myComplexType;
        protected XSType restrictedType;

        public XSComplexTypeImpl(XSType pOwner, XsTComplexType pType) {
            this.owner = pOwner;
            this.myComplexType = pType;
        }

        protected XsTComplexType getXsTComplexType() {
            return this.myComplexType;
        }

        protected XSType getOwner() {
            return this.owner;
        }

        public boolean isSequence() {
            return false;
        }

        public boolean isChoice() {
            return false;
        }

        public boolean isAll() {
            return false;
        }

        public boolean hasSimpleContent() {
            return false;
        }

        public XSSimpleContentType getSimpleContent() {
            throw new IllegalStateException("This complex type doesn't have simple content.");
        }

        public boolean hasComplexContent() {
            return false;
        }

        public boolean isEmpty() throws SAXException {
            return XsComplexContentType.EMPTY.equals(this.getComplexContentType());
        }

        public boolean isElementOnly() throws SAXException {
            return XsComplexContentType.ELEMENT_ONLY.equals(this.getComplexContentType());
        }

        public boolean isMixed() throws SAXException {
            return XsComplexContentType.MIXED.equals(this.getComplexContentType());
        }

        public void validate() throws SAXException {
        }

        public boolean isExtension() throws SAXException {
            return false;
        }

        public XSType getExtendedType() throws SAXException {
            throw new IllegalStateException("This type is no extension.");
        }

        public boolean isRestriction() {
            return this.restrictedType != null;
        }

        public XSType getRestrictedType() {
            if (this.restrictedType == null) {
                throw new IllegalStateException("This type is no restriction.");
            }
            return this.restrictedType;
        }
    }
}

