/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationEventLocator;
import javax.xml.bind.helpers.ParseConversionEventImpl;
import javax.xml.bind.helpers.ValidationEventLocatorImpl;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.JMManager;
import org.apache.ws.jaxme.JMUnmarshaller;
import org.apache.ws.jaxme.JMUnmarshallerHandler;
import org.apache.ws.jaxme.Observer;
import org.apache.ws.jaxme.ValidationEvents;
import org.apache.ws.jaxme.impl.JAXBContextImpl;
import org.apache.ws.jaxme.impl.JMSAXElementParser;
import org.apache.ws.jaxme.impl.JMSAXGroupParser;
import org.apache.ws.jaxme.impl.ValidationEventImpl;
import org.apache.ws.jaxme.util.NamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JMUnmarshallerHandlerImpl
implements JMUnmarshallerHandler {
    private static final int STATE_SIMPLE_ATOMIC = 1;
    private static final int STATE_COMPLEX_CONTENT = 3;
    private static final int STATE_GROUP = 4;
    private final JMUnmarshaller unmarshaller;
    private Locator locator;
    private NamespaceSupport nss = new NamespaceSupport();
    private final List groupParsers = new ArrayList();
    private JMSAXGroupParser activeParser;
    private int level;
    private int endLevel;
    private int state;
    private final StringBuffer sb = new StringBuffer();
    private Observer observer;
    private Object result;

    public int getLevel() {
        return this.level;
    }

    private boolean removeActiveParser() {
        int size = this.groupParsers.size();
        this.groupParsers.remove(--size);
        if (size == 0) {
            return false;
        }
        this.activeParser = (JMSAXGroupParser)this.groupParsers.get(--size);
        if (this.activeParser instanceof JMSAXElementParser) {
            this.state = 3;
            this.endLevel = ((JMSAXElementParser)this.activeParser).getEndLevel();
        } else {
            this.state = 4;
        }
        return true;
    }

    public void setObserver(Observer pObserver) {
        this.observer = pObserver;
    }

    public Observer getObserver() {
        return this.observer;
    }

    public JMUnmarshallerHandlerImpl(JMUnmarshaller pUnmarshaller) {
        this.unmarshaller = pUnmarshaller;
    }

    public JMUnmarshaller getJMUnmarshaller() {
        return this.unmarshaller;
    }

    public void setDocumentLocator(Locator pLocator) {
        this.locator = pLocator;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        this.nss.declarePrefix(pPrefix, pURI);
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        this.nss.undeclarePrefix(pPrefix);
    }

    public boolean testGroupParser(JMSAXGroupParser pParser, String pNamespaceURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        this.groupParsers.add(pParser);
        this.activeParser = pParser;
        this.state = 4;
        if (pParser.startElement(pNamespaceURI, pLocalName, pQName, pAttrs)) {
            return true;
        }
        this.removeActiveParser();
        return false;
    }

    public void addElementParser(JMSAXElementParser pParser) {
        this.endLevel = pParser.getEndLevel();
        this.groupParsers.add(pParser);
        this.activeParser = pParser;
        this.state = 3;
        if (pParser.isAtomic()) {
            this.sb.setLength(0);
        }
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAttrs) throws SAXException {
        if (this.level++ == 0) {
            JMManager manager;
            JAXBContextImpl context = this.unmarshaller.getJAXBContextImpl();
            QName qName = new QName(pNamespaceURI, pLocalName);
            try {
                manager = context.getManager(qName);
            }
            catch (JAXBException e) {
                throw new SAXException("Unable to instantiate manager for element " + qName, (Exception)((Object)e));
            }
            Object o = manager.getElementS();
            JMSAXElementParser parser = manager.getHandler();
            parser.init(this, o, pNamespaceURI, pLocalName, 1);
            parser.setAttributes(pAttrs);
            this.groupParsers.clear();
            this.result = o;
            this.addElementParser(parser);
        } else {
            if (this.state == 3 || this.state == 4) {
                do {
                    if (!this.activeParser.startElement(pNamespaceURI, pLocalName, pQName, pAttrs)) continue;
                    return;
                } while (this.state == 4 && this.removeActiveParser());
            }
            QName qName = new QName(pNamespaceURI, pLocalName);
            this.validationEvent(0, "Unexpected element: '" + qName + "'", "JM_EVENT_UNEXPECTED_CHILD_ELEMENT", null);
        }
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
        int lvl = this.level--;
        switch (this.state) {
            case 4: {
                while (this.state == 4) {
                    if (!this.activeParser.isFinished()) continue;
                    this.removeActiveParser();
                }
                if (this.state != 3) break;
            }
            case 3: {
                JMSAXElementParser elementParser = (JMSAXElementParser)this.activeParser;
                if (lvl != this.endLevel) {
                    if (this.endLevel > lvl) {
                        this.validationEvent(1, "Premature endElement: " + new QName(pNamespaceURI, pLocalName), ValidationEvents.EVENT_PREMATURE_END_ELEMENT, null);
                        while (this.endLevel > lvl) {
                            this.terminateComplexType(pNamespaceURI, pLocalName, pQName, elementParser);
                        }
                    } else {
                        throw new IllegalStateException("Expected level " + this.endLevel + ", got " + lvl);
                    }
                }
                if (elementParser.isAtomic()) {
                    elementParser.endElement(pNamespaceURI, pLocalName, pQName, this.sb.toString());
                }
                if (!pNamespaceURI.equals(elementParser.getNamespaceURI()) || !pLocalName.equals(elementParser.getLocalName()) || !this.activeParser.isFinished()) break;
                this.terminateComplexType(pNamespaceURI, pLocalName, pQName, elementParser);
                return;
            }
            case 1: {
                String s = this.sb.toString();
                this.resetAtomicState();
                this.activeParser.endElement(pNamespaceURI, pLocalName, pQName, s);
                return;
            }
            default: {
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }
        QName qName = new QName(pNamespaceURI, pLocalName);
        this.validationEvent(0, "Unexpected end element: '" + qName + "'", ValidationEvents.EVENT_PREMATURE_END_ELEMENT, null);
    }

    private void terminateComplexType(String pNamespaceURI, String pLocalName, String pQName, JMSAXElementParser elementParser) throws SAXException {
        if (this.removeActiveParser()) {
            this.activeParser.endElement(pNamespaceURI, pLocalName, pQName, elementParser.result);
        } else if (this.observer != null) {
            this.observer.notify(this.result);
        }
    }

    public void characters(char[] pChars, int pOffset, int pLen) throws SAXException {
        switch (this.state) {
            case 1: {
                this.sb.append(pChars, pOffset, pLen);
                return;
            }
            case 3: {
                if (((JMSAXElementParser)this.activeParser).isAtomic()) {
                    this.sb.append(pChars, pOffset, pLen);
                    return;
                }
            }
            case 4: {
                this.activeParser.addText(pChars, pOffset, pLen);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state: " + this.state);
            }
        }
    }

    public void ignorableWhitespace(char[] pChars, int pStart, int pLen) throws SAXException {
        this.characters(pChars, pStart, pLen);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        this.validationEvent(0, "Don't know how to handle processing instructions.", "JM_EVENT_PROCESSING_INSTRUCTION", null);
    }

    public void parseConversionEvent(String pMsg, Exception pException) throws SAXException {
        ParseConversionEventImpl event = new ParseConversionEventImpl(2, pMsg, null);
        this.handleEvent((javax.xml.bind.helpers.ValidationEventImpl)event, pException);
    }

    public void validationEvent(int pSeverity, String pMsg, String pErrorCode, Exception pException) throws SAXException {
        ValidationEventImpl event = new ValidationEventImpl(pSeverity, pMsg, null);
        event.setErrorCode(pErrorCode);
        this.handleEvent(event, pException);
    }

    private void handleEvent(javax.xml.bind.helpers.ValidationEventImpl pEvent, Exception pException) throws SAXException {
        ValidationEventHandler eventHandler;
        if (this.locator != null) {
            pEvent.setLocator((ValidationEventLocator)new ValidationEventLocatorImpl(this.locator));
        }
        if (pException != null) {
            pEvent.setLinkedException((Throwable)pException);
        }
        try {
            eventHandler = this.unmarshaller.getEventHandler();
        }
        catch (JAXBException e) {
            throw new SAXException((Exception)((Object)e));
        }
        if (eventHandler == null || !eventHandler.handleEvent((ValidationEvent)pEvent)) {
            String errorCode;
            String msg = pEvent.getMessage();
            if (pEvent instanceof ValidationEventImpl && (errorCode = ((ValidationEventImpl)pEvent).getErrorCode()) != null) {
                msg = errorCode + ": " + msg;
            }
            throw new SAXParseException(msg, this.locator, pException);
        }
    }

    public void skippedEntity(String pName) throws SAXException {
        this.validationEvent(0, "Don't know how to handle skipped entities.", "JM_EVENT_SKIPPED_ENTITY", null);
    }

    public Object getResult() throws JAXBException, IllegalStateException {
        if (this.groupParsers.size() > 0 || this.result == null) {
            throw new IllegalStateException("Parsing the element is not yet finished.");
        }
        return this.result;
    }

    public NamespaceSupport getNamespaceSupport() {
        return this.nss;
    }

    public Locator getDocumentLocator() {
        return this.locator;
    }

    public DatatypeConverterInterface getDatatypeConverter() {
        return this.unmarshaller.getDatatypeConverter();
    }

    public void addSimpleAtomicState() {
        this.activeParser = null;
        this.sb.setLength(0);
        this.state = 1;
    }

    private void resetAtomicState() {
        this.activeParser = (JMSAXGroupParser)this.groupParsers.get(this.groupParsers.size() - 1);
        this.state = this.activeParser instanceof JMSAXElementParser ? 3 : 4;
    }
}

