/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.util.Base64Binary;
import org.apache.ws.jaxme.util.Duration;
import org.apache.ws.jaxme.util.HexBinary;
import org.apache.ws.jaxme.xs.util.XsDateFormat;
import org.apache.ws.jaxme.xs.util.XsDateTimeFormat;
import org.apache.ws.jaxme.xs.util.XsTimeFormat;

public class DatatypeConverterImpl
implements DatatypeConverterInterface {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private static final int MAX_UNSIGNED_SHORT = 65535;

    public String parseString(String arg0) {
        return arg0;
    }

    public BigInteger parseInteger(String arg0) {
        return new BigInteger(arg0);
    }

    public int parseInt(String arg0) {
        return Integer.parseInt(arg0);
    }

    public long parseLong(String arg0) {
        return Long.parseLong(arg0);
    }

    public short parseShort(String arg0) {
        return Short.parseShort(arg0);
    }

    public BigDecimal parseDecimal(String arg0) {
        return new BigDecimal(arg0);
    }

    public float parseFloat(String arg0) {
        return Float.parseFloat(arg0);
    }

    public double parseDouble(String arg0) {
        return Double.parseDouble(arg0);
    }

    public boolean parseBoolean(String arg0) {
        return Boolean.valueOf(arg0);
    }

    public byte parseByte(String arg0) {
        return Byte.parseByte(arg0);
    }

    public QName parseQName(String arg0, NamespaceContext arg1) {
        String uri;
        String localName;
        int offset = arg0.indexOf(58);
        switch (offset) {
            case -1: {
                localName = arg0;
                uri = arg1.getNamespaceURI("");
                if (uri != null) break;
                throw new IllegalArgumentException("The default prefix is not bound.");
            }
            case 0: {
                throw new IllegalArgumentException("Default prefix must be indicated by not using a colon: " + arg0);
            }
            default: {
                String prefix = arg0.substring(0, offset);
                localName = arg0.substring(offset + 1);
                uri = arg1.getNamespaceURI(prefix);
                if (uri != null) break;
                throw new IllegalArgumentException("The prefix " + prefix + " is not bound.");
            }
        }
        return new QName(uri, localName);
    }

    public Calendar parseDateTime(String arg0) {
        XsDateTimeFormat format = new XsDateTimeFormat();
        ParsePosition pos = new ParsePosition(0);
        Calendar cal = (Calendar)format.parseObject(arg0, pos);
        if (cal == null) {
            throw new IllegalArgumentException("Failed to parse dateTime " + arg0 + " at:" + arg0.substring(pos.getErrorIndex()));
        }
        return cal;
    }

    public byte[] parseBase64Binary(String arg0) {
        try {
            return Base64Binary.decode(arg0);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse " + arg0 + ": " + e.getMessage());
        }
    }

    public byte[] parseHexBinary(String arg0) {
        return HexBinary.decode(arg0);
    }

    public long parseUnsignedInt(String arg0) {
        long l = Long.parseLong(arg0);
        if (l < 0L) {
            throw new IllegalArgumentException("Failed to parse UnsignedInt " + arg0 + ": result is negative");
        }
        if (l > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Failed to parse UnsignedInt " + arg0 + ": result exceeds maximum value " + 0xFFFFFFFFL);
        }
        return l;
    }

    public int parseUnsignedShort(String arg0) {
        int i = Integer.parseInt(arg0);
        if (i < 0) {
            throw new IllegalArgumentException("Failed to parse UnsignedShort " + arg0 + ": result is negative");
        }
        if (i > 65535) {
            throw new IllegalArgumentException("Failed to parse UnsignedShort " + arg0 + ": result exceeds maximum value " + 65535);
        }
        return i;
    }

    public Calendar parseTime(String arg0) {
        XsTimeFormat format = new XsTimeFormat();
        ParsePosition pos = new ParsePosition(0);
        Calendar cal = (Calendar)format.parseObject(arg0, pos);
        if (cal == null) {
            throw new IllegalArgumentException("Failed to parse time " + arg0 + " at:" + arg0.substring(pos.getErrorIndex()));
        }
        return cal;
    }

    public Calendar parseDate(String arg0) {
        XsDateFormat format = new XsDateFormat();
        ParsePosition pos = new ParsePosition(0);
        Calendar cal = (Calendar)format.parseObject(arg0, pos);
        if (cal == null) {
            throw new IllegalArgumentException("Failed to parse date " + arg0 + " at:" + arg0.substring(pos.getErrorIndex()));
        }
        return cal;
    }

    public String parseAnySimpleType(String arg0) {
        return arg0;
    }

    public Duration parseDuration(String pDuration) {
        return Duration.valueOf(pDuration);
    }

    public String printString(String arg0) {
        return arg0;
    }

    public String printInteger(BigInteger arg0) {
        return arg0.toString();
    }

    public String printInt(int arg0) {
        return Integer.toString(arg0);
    }

    public String printLong(long arg0) {
        return Long.toString(arg0);
    }

    public String printShort(short arg0) {
        return Short.toString(arg0);
    }

    public String printDecimal(BigDecimal arg0) {
        return arg0.toString();
    }

    public String printFloat(float arg0) {
        return Float.toString(arg0);
    }

    public String printDouble(double arg0) {
        return Double.toString(arg0);
    }

    public String printBoolean(boolean arg0) {
        return (arg0 ? Boolean.TRUE : Boolean.FALSE).toString();
    }

    public String printByte(byte arg0) {
        return Byte.toString(arg0);
    }

    public String printQName(QName arg0, NamespaceContext arg1) {
        String prefix = arg1.getPrefix(arg0.getNamespaceURI());
        if (prefix == null) {
            throw new IllegalArgumentException("The namespace URI " + arg0.getNamespaceURI() + " is not bound.");
        }
        if ("".equals(prefix)) {
            return arg0.getLocalPart();
        }
        return prefix + ":" + arg0.getLocalPart();
    }

    public String printDateTime(Calendar arg0) {
        return new XsDateTimeFormat().format((Object)arg0);
    }

    public String printBase64Binary(byte[] arg0) {
        return Base64Binary.encode(arg0);
    }

    public String printHexBinary(byte[] arg0) {
        return HexBinary.encode(arg0);
    }

    public String printUnsignedInt(long arg0) {
        return Long.toString(arg0);
    }

    public String printUnsignedShort(int arg0) {
        return Integer.toString(arg0);
    }

    public String printTime(Calendar arg0) {
        return new XsTimeFormat().format((Object)arg0);
    }

    public String printDate(Calendar arg0) {
        return new XsDateFormat().format((Object)arg0);
    }

    public String printAnySimpleType(String arg0) {
        return arg0;
    }

    public String printDuration(Duration pDuration) {
        return pDuration.toString();
    }
}

