/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DateFilter {
    private File fromFile;
    private File toFile;
    private boolean force;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$util$DateFilter;

    public void setFromFile(File pFile) {
        this.fromFile = pFile;
    }

    public File getFromFile() {
        return this.fromFile;
    }

    public void setToFile(File pFile) {
        this.toFile = pFile;
    }

    public File getToFile() {
        return this.toFile;
    }

    public void setForce(boolean pForce) {
        this.force = pForce;
    }

    public boolean getForce() {
        return this.force;
    }

    public String validate() {
        StringBuffer result = new StringBuffer();
        if (this.fromFile == null) {
            result.append("Input file (option fromFile) is not set.\n");
        } else if (!this.fromFile.exists()) {
            result.append("Input file " + this.fromFile + " doesn't exist.");
        }
        if (this.toFile == null) {
            result.append("toFile is not set.\n");
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    public boolean isRunning() {
        if (this.getForce()) {
            return true;
        }
        long l1 = this.fromFile.lastModified();
        if (l1 == -1L) {
            return true;
        }
        long l2 = this.toFile.lastModified();
        if (l2 == -1L) {
            return true;
        }
        return l2 <= l1;
    }

    public List getLines() throws IOException {
        String s;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(this.getFromFile()));
        while ((s = br.readLine()) != null) {
            result.add(s);
        }
        return result;
    }

    public Calendar getCalendar(String pDateTime, String pPattern) throws ParseException {
        SimpleDateFormat simpleFormat = new SimpleDateFormat(pPattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(simpleFormat.parse(pDateTime));
        return cal;
    }

    public String replacePattern(String pPattern, String pSourceFormat, DateFormat pTargetFormat) throws ParseException {
        return pTargetFormat.format(this.getCalendar(pPattern, pSourceFormat).getTime());
    }

    public String getDateTime(String pDateTime) throws ParseException {
        return this.replacePattern(pDateTime, "yyyy-MM-dd HH:mm:ss", DateFormat.getDateTimeInstance());
    }

    public String getDate(String pDateTime) throws ParseException {
        return this.replacePattern(pDateTime, "yyyy-MM-dd", DateFormat.getDateInstance());
    }

    public String getTime(String pDateTime) throws ParseException {
        return this.replacePattern(pDateTime, "HH:mm:ss", DateFormat.getTimeInstance());
    }

    public void replace(List pLines, List fromStrings, List toStrings) {
        ListIterator<String> iter = pLines.listIterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            StringBuffer result = new StringBuffer();
            while (s.length() > 0) {
                boolean done = false;
                for (int i = 0; i < fromStrings.size(); ++i) {
                    String from = (String)fromStrings.get(i);
                    if (!s.startsWith(from)) continue;
                    result.append((String)toStrings.get(i));
                    s = s.substring(from.length());
                    done = true;
                    break;
                }
                if (done) continue;
                result.append(s.charAt(0));
                s = s.substring(1);
            }
            iter.set(result.toString());
        }
    }

    public void putLines(List pLines) throws IOException {
        BufferedWriter fw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.getToFile()), "UTF-8"));
        Iterator iter = pLines.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            fw.write(s + "\n");
        }
        ((Writer)fw).close();
    }

    public void execute() throws IOException, ParseException {
        if (!this.isRunning()) {
            return;
        }
        List lines = this.getLines();
        ArrayList<String> fromStrings = new ArrayList<String>();
        ArrayList<String> toStrings = new ArrayList<String>();
        fromStrings.add("2002-12-17 12:23:11");
        toStrings.add(this.getDateTime("2002-12-17 12:23:11"));
        fromStrings.add("2002-12-16 12:00:11");
        toStrings.add(this.getDateTime("2002-12-16 12:00:11"));
        fromStrings.add("2002-12-17");
        toStrings.add(this.getDate("2002-12-17"));
        fromStrings.add("2002-12-16");
        toStrings.add(this.getDate("2002-12-16"));
        fromStrings.add("12:23:11");
        toStrings.add(this.getTime("12:23:11"));
        fromStrings.add("12:00:11");
        toStrings.add(this.getTime("12:00:11"));
        this.replace(lines, fromStrings, toStrings);
        this.putLines(lines);
    }

    public static void Usage(String pMsg) {
        PrintStream ps = System.err;
        if (pMsg != null) {
            ps.println(pMsg);
            ps.println();
        }
        ps.println("Usage: java " + (class$org$apache$ws$jaxme$generator$util$DateFilter == null ? (class$org$apache$ws$jaxme$generator$util$DateFilter = DateFilter.class$("org.apache.ws.jaxme.generator.util.DateFilter")) : class$org$apache$ws$jaxme$generator$util$DateFilter) + " <options>");
        ps.println();
        ps.println("Possible options are:");
        ps.println(" --fromFile <file>    Sets the input file");
        ps.println(" --toFile <file>      Sets the output file");
        ps.println(" --force              Forces overwriting of the output file");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        DateFilter filter = new DateFilter();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        while (!argList.isEmpty()) {
            String arg = (String)argList.remove(0);
            String opt = null;
            if (arg.startsWith("--")) {
                opt = arg.substring(2);
            } else if (arg.startsWith("-")) {
                opt = arg.substring(1);
            } else {
                DateFilter.Usage("Unknown argument: " + arg);
            }
            if ("fromFile".equals(opt)) {
                if (argList.isEmpty()) {
                    DateFilter.Usage("Option " + arg + " requires an argument: Input file");
                }
                filter.setFromFile(new File((String)argList.remove(0)));
                continue;
            }
            if ("toFile".equals(opt)) {
                if (argList.isEmpty()) {
                    DateFilter.Usage("Option " + arg + " requires an argument: Output file");
                }
                filter.setToFile(new File((String)argList.remove(0)));
                continue;
            }
            if ("force".equals(opt)) {
                filter.setForce(true);
                continue;
            }
            DateFilter.Usage("Unknown option: " + opt);
        }
        String msg = filter.validate();
        if (msg != null) {
            DateFilter.Usage(msg);
        } else {
            filter.execute();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

