/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.types;

import org.apache.ws.jaxme.generator.sg.AtomicTypeSG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGlet;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.SimpleTypeSG;
import org.apache.ws.jaxme.generator.types.AtomicTypeSGImpl;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.TypedValue;
import org.apache.ws.jaxme.js.impl.TypedValueImpl;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.xml.sax.SAXException;

public class StringSG
extends AtomicTypeSGImpl {
    public static final JavaQName STRING_TYPE = JavaQNameImpl.getInstance((Class)(class$java$lang$String == null ? (class$java$lang$String = StringSG.class$("java.lang.String")) : class$java$lang$String));
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public StringSG(SGFactory pFactory, SchemaSG pSchema, XSType pType) throws SAXException {
        super(pFactory, pSchema, pType);
    }

    protected String getDatatypeName() {
        return "String";
    }

    protected JavaQName getDatatypeType() {
        return STRING_TYPE;
    }

    public JavaQName getRuntimeType(SimpleTypeSG pController) {
        return STRING_TYPE;
    }

    public TypedValue getCastFromString(SimpleTypeSG pController, String pValue) {
        return new TypedValueImpl((Object)JavaSource.getQuoted((String)pValue), STRING_TYPE);
    }

    public TypedValue getCastFromString(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, Object pData) {
        return new TypedValueImpl(pValue, STRING_TYPE);
    }

    public TypedValue getCastToString(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, DirectAccessible pData) {
        return new TypedValueImpl(pValue, STRING_TYPE);
    }

    public void forAllNonNullValues(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, SGlet pSGlet) throws SAXException {
        LocalJavaField f = pMethod.newJavaField(STRING_TYPE);
        f.addLine(pValue);
        pMethod.addIf((Object)f, (Object)" != null");
        pSGlet.generate(pMethod, pValue);
        pMethod.addEndIf();
    }

    public void forAllValues(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, SGlet pSGlet) throws SAXException {
        pSGlet.generate(pMethod, pValue);
    }

    public boolean isCausingParseConversionEvent(SimpleTypeSG pController) {
        AtomicTypeSG atomicType = pController.getAtomicType();
        return atomicType.getLength() != null || atomicType.getMinLength() != null || atomicType.getMaxLength() != null;
    }

    public void addValidation(SimpleTypeSG pController, JavaMethod pMethod, DirectAccessible pValue) throws SAXException {
        AtomicTypeSG atomicType = pController.getAtomicType();
        Long length = atomicType.getLength();
        Long maxLength = atomicType.getMaxLength();
        Long minLength = atomicType.getMinLength();
        if (minLength != null && minLength < 0L) {
            throw new LocSAXException("Negative value for minLength detected: " + minLength, this.getLocator());
        }
        if (maxLength != null) {
            if (maxLength < 0L) {
                throw new LocSAXException("Negative value for maxLength detected: " + maxLength, this.getLocator());
            }
            if (minLength != null) {
                if (maxLength < minLength) {
                    throw new LocSAXException("MaxLength value of " + maxLength + " is smaller than minLength value of " + minLength, this.getLocator());
                }
                if (maxLength.longValue() == minLength.longValue()) {
                    length = maxLength;
                }
            }
        }
        if (length != null) {
            if (length < 0L) {
                throw new LocSAXException("Negative value for length detected: " + length, this.getLocator());
            }
            if (maxLength != null) {
                if (maxLength < length) {
                    throw new LocSAXException("MaxLength value of " + maxLength + " is smaller than length value of " + length, this.getLocator());
                }
                maxLength = null;
            }
            if (minLength != null) {
                if (minLength > length) {
                    throw new LocSAXException("MinLength value of " + minLength + " is larger than length value of " + length, this.getLocator());
                }
                minLength = null;
            }
        }
        if (length != null || maxLength != null || minLength != null) {
            if (pValue.isNullable()) {
                pMethod.addIf((Object)pValue, (Object)" != null");
            }
            if (maxLength != null) {
                pMethod.addIf((Object)pValue, (Object)".length()", (Object)" > ", (Object)maxLength);
                pMethod.addThrowNew(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = StringSG.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, (Object)JavaSource.getQuoted((String)("Length of " + maxLength + " characters exceeded: ")), (Object)" + ", (Object)pValue);
                pMethod.addEndIf();
            }
            if (minLength != null) {
                pMethod.addIf((Object)pValue, (Object)".length()", (Object)" < ", (Object)minLength);
                pMethod.addThrowNew(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = StringSG.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, (Object)JavaSource.getQuoted((String)("Minimum length of " + minLength + " characters not matched: ")), (Object)" + ", (Object)pValue);
                pMethod.addEndIf();
            }
            if (length != null) {
                pMethod.addIf((Object)pValue, (Object)".length()", (Object)" != ", (Object)length);
                pMethod.addThrowNew(class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = StringSG.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException, (Object)JavaSource.getQuoted((String)("Length of " + length + " characters not matched: ")), (Object)" + ", (Object)pValue);
                pMethod.addEndIf();
            }
            if (pValue.isNullable()) {
                pMethod.addEndIf();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

