/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.types;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.ListTypeSG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGlet;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.SimpleTypeSG;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.types.SimpleTypeSGImpl;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.TypedValue;
import org.apache.ws.jaxme.js.impl.TypedValueImpl;
import org.apache.ws.jaxme.xs.XSListType;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.SAXException;

public class ListTypeSGImpl
extends SimpleTypeSGImpl {
    public static final JavaQName LIST_TYPE = JavaQNameImpl.getInstance((Class)(class$java$util$List == null ? (class$java$util$List = ListTypeSGImpl.class$("java.util.List")) : class$java$util$List));
    public static final JavaQName ARRAYLIST_TYPE = JavaQNameImpl.getInstance((Class)(class$java$util$ArrayList == null ? (class$java$util$ArrayList = ListTypeSGImpl.class$("java.util.ArrayList")) : class$java$util$ArrayList));
    private final XSListType listType;
    private final ListTypeSG listTypeSG;
    private TypeSG itemType;
    private final Context classContext;
    private final XsQName name;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;
    static /* synthetic */ Class class$java$util$Arrays;
    static /* synthetic */ Class class$java$util$StringTokenizer;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$java$lang$String;

    public boolean hasSetMethod(SimpleTypeSG pController) {
        return "indexed".equals(pController.getCollectionType());
    }

    public boolean isList(SimpleTypeSG pController) {
        return true;
    }

    public ListTypeSGImpl(SGFactory pFactory, SchemaSG pSchemaSG, XSType pType, Context pClassContext, XsQName pName) throws SAXException {
        super(pFactory, pSchemaSG, pType);
        this.name = pName;
        this.classContext = pClassContext;
        this.listType = pType.getSimpleType().getListType();
        this.listTypeSG = new InnerListTypeSG(this.listType);
    }

    public void init(SimpleTypeSG pController) throws SAXException {
        this.itemType = this.getFactory().getTypeSG(this.listType.getItemType(), this.classContext, this.name, null);
    }

    protected TypeSG getItemType() {
        return this.itemType;
    }

    public ListTypeSG getListType(SimpleTypeSG pController) {
        return this.listTypeSG;
    }

    public JavaQName getRuntimeType(SimpleTypeSG pController) {
        if ("indexed".equals(pController.getCollectionType())) {
            return JavaQNameImpl.getArray((JavaQName)this.itemType.getSimpleTypeSG().getRuntimeType());
        }
        return LIST_TYPE;
    }

    public TypedValue getCastFromString(SimpleTypeSG pController, String pValue) throws SAXException {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(pValue);
        while (st.hasMoreElements()) {
            if (list.size() > 0) {
                list.add(", ");
            }
            list.add((String)this.itemType.getSimpleTypeSG().getCastFromString(st.nextToken()));
        }
        Object[] result = new Object[]{"new ", this.itemType.getSimpleTypeSG().getRuntimeType(), "[]{", list, "}"};
        String collectionType = pController.getCollectionType();
        if ("indexed".equals(collectionType)) {
            return new TypedValueImpl((Object)result, this.itemType.getSimpleTypeSG().getRuntimeType());
        }
        JavaQName myListType = JavaQNameImpl.getInstance((String)collectionType);
        return new TypedValueImpl((Object)new Object[]{"(new ", myListType, "(", class$java$util$Arrays == null ? (class$java$util$Arrays = ListTypeSGImpl.class$("java.util.Arrays")) : class$java$util$Arrays, ".asList(", result, ")))"}, myListType);
    }

    public TypedValue getCastFromString(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, Object pData) throws SAXException {
        LocalJavaField list = pMethod.newJavaField(LIST_TYPE);
        String collectionType = pController.getCollectionType();
        list.addLine((Object)"new ", (Object)("indexed".equals(collectionType) ? ARRAYLIST_TYPE : JavaQNameImpl.getInstance((String)collectionType)), (Object)"()");
        DirectAccessible st = pMethod.addForEnumeration(class$java$util$StringTokenizer == null ? (class$java$util$StringTokenizer = ListTypeSGImpl.class$("java.util.StringTokenizer")) : class$java$util$StringTokenizer, (Object)new Object[]{"new ", class$java$util$StringTokenizer == null ? (class$java$util$StringTokenizer = ListTypeSGImpl.class$("java.util.StringTokenizer")) : class$java$util$StringTokenizer, "(", pValue, ")"});
        pMethod.addLine((Object)list, (Object)".add(", (Object)this.itemType.getSimpleTypeSG().getCastFromString(pMethod, new Object[]{st, ".nextToken()"}, pData), (Object)");");
        pMethod.addEndFor();
        if ("indexed".equals(collectionType)) {
            JavaQName iType = this.itemType.getSimpleTypeSG().getRuntimeType();
            return new TypedValueImpl((Object)new Object[]{"((", iType, ") ", list, ".toArray(new ", iType, "[", list, ".size()]))"}, this.itemType.getSimpleTypeSG().getRuntimeType());
        }
        JavaQName myListType = JavaQNameImpl.getInstance((String)collectionType);
        return new TypedValueImpl((Object)list, myListType);
    }

    public TypedValue getCastToString(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, DirectAccessible pData) throws SAXException {
        Object[] v;
        DirectAccessible loopVar;
        DirectAccessible value;
        String collectionType = pController.getCollectionType();
        if (pValue instanceof DirectAccessible) {
            value = (DirectAccessible)pValue;
        } else {
            LocalJavaField v2 = pMethod.newJavaField(pController.getRuntimeType());
            v2.addLine(pValue);
            value = v2;
        }
        LocalJavaField sb = pMethod.newJavaField(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = ListTypeSGImpl.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer);
        sb.addLine((Object)"new ", (Object)(class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = ListTypeSGImpl.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer), (Object)"()");
        if ("indexed".equals(collectionType)) {
            loopVar = pMethod.addForArray((Object)value);
            v = new Object[]{value, "[", loopVar, "]"};
        } else {
            loopVar = pMethod.addForList((Object)value);
            v = new Object[]{"(", this.itemType.getSimpleTypeSG().getRuntimeType(), ") ", value, ".get(", loopVar, ")"};
        }
        pMethod.addIf((Object)loopVar, (Object)" > 0");
        pMethod.addLine((Object)sb, (Object)".append(' ');");
        pMethod.addEndIf();
        pMethod.addLine((Object)sb, (Object)".append(", (Object)this.itemType.getSimpleTypeSG().getCastToString(pMethod, v, pData), (Object)");");
        pMethod.addEndFor();
        return new TypedValueImpl((Object)new Object[]{sb, ".toString()"}, class$java$lang$String == null ? (class$java$lang$String = ListTypeSGImpl.class$("java.lang.String")) : class$java$lang$String);
    }

    public void forAllNonNullValues(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, SGlet pSGlet) throws SAXException {
        LocalJavaField f = pMethod.newJavaField(LIST_TYPE);
        f.addLine(pValue);
        pMethod.addIf((Object)f, (Object)" != null");
        pSGlet.generate(pMethod, f);
        pMethod.addEndIf();
    }

    public void forAllValues(SimpleTypeSG pController, JavaMethod pMethod, Object pValue, SGlet pSGlet) throws SAXException {
        pSGlet.generate(pMethod, pValue);
    }

    public Object getEqualsCheck(SimpleTypeSG pController, JavaMethod pMethod, Object pValue1, Object pValue2) throws SAXException {
        throw new IllegalStateException("Not implemented");
    }

    public Object getInitialValue(SimpleTypeSG pController, JavaSource p0) throws SAXException {
        String s = pController.getCollectionType();
        JavaQName listClass = "indexed".equals(s) ? ARRAYLIST_TYPE : JavaQNameImpl.getInstance((String)s);
        return new Object[]{"new ", listClass, "()"};
    }

    public boolean isCausingParseConversionEvent(SimpleTypeSG pController) {
        return this.itemType.getSimpleTypeSG().isCausingParseConversionEvent();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class InnerListTypeSG
    implements ListTypeSG {
        private final Long length;
        private final Long minLength;
        private final Long maxLength;

        public InnerListTypeSG(XSListType pListType) {
            this.length = pListType.getLength();
            this.maxLength = pListType.getMaxLength();
            this.minLength = pListType.getMinLength();
        }

        public TypeSG getItemType() {
            return ListTypeSGImpl.this.getItemType();
        }

        public Long getLength() {
            return this.length;
        }

        public Long getMaxLength() {
            return this.maxLength;
        }

        public Long getMinLength() {
            return this.minLength;
        }
    }
}

