/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl.ccsg;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ws.jaxme.generator.sg.ComplexContentSG;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.PropertySG;
import org.apache.ws.jaxme.generator.sg.PropertySGChain;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.impl.PropertySGChainImpl;
import org.apache.ws.jaxme.generator.sg.impl.PropertySGImpl;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.AllHandlerSG;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.ChoiceHandlerSG;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.GroupUtil;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.HandlerSG;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.HandlerSGImpl;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.SequenceHandlerSG;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaField;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.LocalJavaField;
import org.apache.ws.jaxme.js.Parameter;
import org.apache.ws.jaxme.js.TypedValue;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.SAXException;

public abstract class GroupHandlerSG
extends HandlerSGImpl {
    protected final ComplexContentSG ccSG;
    protected final ParticleSG particle;
    protected final GroupSG group;
    protected final ParticleSG[] particles;
    private final Map groups = new HashMap();
    private JavaField stateField;
    private final boolean isMixed;
    protected final GroupHandlerSG outerHandler;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$JMSAXGroupParser;
    static /* synthetic */ Class class$org$apache$ws$jaxme$JMManager;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$JMSAXElementParser;
    static /* synthetic */ Class class$java$lang$IllegalStateException;
    static /* synthetic */ Class array$C;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$org$apache$ws$jaxme$impl$JMUnmarshallerHandlerImpl;

    protected GroupHandlerSG(ComplexTypeSG pType, JavaSource pJs) throws SAXException {
        super(pType, pJs);
        this.outerHandler = this;
        this.ccSG = pType.getComplexContentSG();
        this.particle = this.ccSG.getRootParticle();
        this.group = this.particle.getGroupSG();
        this.particles = this.group.getParticles();
        this.isMixed = this.ccSG.isMixed();
        this.findGroups(this.particles);
    }

    protected GroupHandlerSG(GroupHandlerSG pOuterHandler, ComplexTypeSG pType, ParticleSG pParticle, JavaSource pJs) throws SAXException {
        super(pType, pJs);
        this.outerHandler = pOuterHandler;
        if (!pJs.isInnerClass()) {
            throw new IllegalStateException("Expected inner class");
        }
        this.ccSG = null;
        this.particle = pParticle;
        this.group = this.particle.getGroupSG();
        this.particles = this.group.getParticles();
        this.isMixed = pType.getComplexContentSG().isMixed();
        this.findGroups(this.particles);
    }

    protected abstract JavaField newStateField() throws SAXException;

    protected JavaField getStateField() throws SAXException {
        if (this.stateField == null) {
            this.stateField = this.newStateField();
        }
        return this.stateField;
    }

    protected GroupHandlerSG getGroupHandlerSG(GroupSG pGroup) {
        return (GroupHandlerSG)this.groups.get(pGroup);
    }

    private GroupHandlerSG newGroupHandlerSG(ParticleSG pParticle, String pName) throws SAXException {
        JavaSource js = this.getJavaSource();
        JavaInnerClass jic = js.newJavaInnerClass(pName, JavaSource.PUBLIC);
        jic.addExtends(class$org$apache$ws$jaxme$impl$JMSAXGroupParser == null ? (class$org$apache$ws$jaxme$impl$JMSAXGroupParser = GroupHandlerSG.class$("org.apache.ws.jaxme.impl.JMSAXGroupParser")) : class$org$apache$ws$jaxme$impl$JMSAXGroupParser);
        GroupSG group = pParticle.getGroupSG();
        if (group.isSequence()) {
            return new SequenceHandlerSG(this.outerHandler, this.ctSG, pParticle, (JavaSource)jic);
        }
        if (group.isChoice()) {
            return new ChoiceHandlerSG(this.outerHandler, this.ctSG, pParticle, (JavaSource)jic);
        }
        if (group.isAll()) {
            return new AllHandlerSG(this.outerHandler, this.ctSG, pParticle, (JavaSource)jic);
        }
        throw new IllegalStateException("Invalid group type");
    }

    private boolean isValidInnerClassName(JavaSource pSource, String pName) {
        String name;
        boolean isInnerClass = pSource.isInnerClass();
        if (isInnerClass) {
            JavaInnerClass jic = (JavaInnerClass)pSource;
            if (!this.isValidInnerClassName(jic.getOuterClass(), pName)) {
                return false;
            }
            name = jic.getQName().getInnerClassName();
        } else {
            name = pSource.getQName().getClassName();
        }
        if (name.equals(pName)) {
            return false;
        }
        return pSource.getInnerClass(pName) == null;
    }

    private GroupHandlerSG newGroupHandlerSG(ParticleSG pParticle) throws SAXException {
        JavaSource js = this.getJavaSource();
        String name = GroupUtil.getGroupName(pParticle.getGroupSG());
        int i = 0;
        while (true) {
            String n = name;
            if (i > 0) {
                name = name + i;
            }
            if (this.isValidInnerClassName(js, n = n + "Handler")) {
                GroupHandlerSG result = this.newGroupHandlerSG(pParticle, n);
                result.newGetHandlerMethod(js);
                return result;
            }
            ++i;
        }
    }

    public JavaMethod newAddAttributeMethod() throws SAXException {
        if (this.ccSG == null) {
            return null;
        }
        return super.newAddAttributeMethod();
    }

    private void findGroups(ParticleSG[] pParticles) throws SAXException {
        for (int i = 0; i < pParticles.length; ++i) {
            TypeSG tSG;
            ParticleSG particle = pParticles[i];
            if (particle.isGroup()) {
                GroupSG group = particle.getGroupSG();
                if (this.groups.containsKey(group)) continue;
                GroupHandlerSG handler = this.newGroupHandlerSG(particle);
                this.groups.put(group, handler);
                continue;
            }
            if (!particle.isElement() || !(tSG = particle.getObjectSG().getTypeSG()).isComplex() || tSG.isGlobalClass()) continue;
            tSG.getComplexTypeSG().getXMLHandler(this.outerHandler.getJavaSource());
        }
    }

    protected boolean isRequiredParticle(ParticleSG particleSG) throws SAXException {
        if (particleSG.getMinOccurs() == 0) {
            return false;
        }
        if (particleSG.isGroup()) {
            GroupSG group = particleSG.getGroupSG();
            ParticleSG[] particles = group.getParticles();
            if (group.isChoice()) {
                for (int i = 0; i < particles.length; ++i) {
                    if (this.isRequiredParticle(particles[i])) continue;
                    return false;
                }
                return true;
            }
            for (int i = 0; i < particles.length; ++i) {
                if (!this.isRequiredParticle(particles[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void handleStartOfChildElement(Object pUnmarshallerHandler, JavaMethod pJm, ParticleSG pParticle) {
        ObjectSG oSG = pParticle.getObjectSG();
        TypeSG tSG = oSG.getTypeSG();
        if (tSG.isComplex()) {
            Object[] h;
            Object[] o;
            if (oSG.getClassContext().isGlobal()) {
                JavaQName elementInterfaceClass = pParticle.getObjectSG().getClassContext().getXMLInterfaceName();
                LocalJavaField manager = pJm.newJavaField(class$org$apache$ws$jaxme$JMManager == null ? (class$org$apache$ws$jaxme$JMManager = GroupHandlerSG.class$("org.apache.ws.jaxme.JMManager")) : class$org$apache$ws$jaxme$JMManager);
                manager.addLine((Object)"getHandler().getJMUnmarshaller().getJAXBContextImpl().getManagerS(", (Object)elementInterfaceClass, (Object)".class)");
                o = new Object[]{manager, ".getElementS();"};
                h = new Object[]{manager, ".getHandler();"};
            } else {
                Context context = oSG.getClassContext();
                o = new Object[]{" new ", context.getXMLImplementationName(), "()"};
                h = new Object[]{" new ", context.getXMLHandlerName(), "()"};
            }
            LocalJavaField oField = pJm.newJavaField(class$java$lang$Object == null ? (class$java$lang$Object = GroupHandlerSG.class$("java.lang.Object")) : class$java$lang$Object);
            oField.addLine(o);
            LocalJavaField hField = pJm.newJavaField(class$org$apache$ws$jaxme$impl$JMSAXElementParser == null ? (class$org$apache$ws$jaxme$impl$JMSAXElementParser = GroupHandlerSG.class$("org.apache.ws.jaxme.impl.JMSAXElementParser")) : class$org$apache$ws$jaxme$impl$JMSAXElementParser);
            hField.addLine(h);
            XsQName name = oSG.getName();
            pJm.addLine((Object)hField, (Object)".init(", pUnmarshallerHandler, (Object)", ", (Object)oField, (Object)", ", (Object)JavaSource.getQuoted((String)name.getNamespaceURI()), (Object)", ", (Object)JavaSource.getQuoted((String)name.getLocalName()), (Object)", ", pUnmarshallerHandler, (Object)".getLevel());");
            pJm.addLine((Object)hField, (Object)".setAttributes(", (Object)this.getParamAttrs(), (Object)");");
            pJm.addLine(pUnmarshallerHandler, (Object)".addElementParser(", (Object)hField, (Object)");");
        } else {
            pJm.addLine(pUnmarshallerHandler, (Object)".addSimpleAtomicState();");
        }
    }

    protected abstract void acceptParticle(JavaMethod var1, int var2) throws SAXException;

    protected void handleStartElementStates(Object pUnmarshallerHandler, JavaMethod pJm, int pFrom, int pTo) throws SAXException {
        if (pFrom < 0 || pFrom >= this.particles.length || pTo < 0 || pTo >= this.particles.length || pTo < pFrom) {
            return;
        }
        for (int i = pFrom; i <= pTo; ++i) {
            ParticleSG particle = this.particles[i];
            if (particle.isElement()) {
                ObjectSG oSG = particle.getObjectSG();
                XsQName name = oSG.getName();
                Object[] uriCondition = "".equals(name.getNamespaceURI()) ? new Object[]{"(", this.getParamNamespaceURI(), " == null  ||  ", this.getParamNamespaceURI(), ".length() == 0)"} : new Object[]{JavaSource.getQuoted((String)name.getNamespaceURI()), ".equals(", this.getParamNamespaceURI(), ")"};
                pJm.addIf(i == pFrom, (Object)uriCondition, (Object)"  &&  ", (Object)JavaSource.getQuoted((String)name.getLocalName()), (Object)".equals(", (Object)this.getParamLocalName(), (Object)")");
                this.acceptParticle(pJm, i);
                this.handleStartOfChildElement(pUnmarshallerHandler, pJm, particle);
                pJm.addLine((Object)"return true;");
                continue;
            }
            if (particle.isGroup()) {
                GroupSG gSG = particle.getGroupSG();
                GroupHandlerSG handlerSG = this.getGroupHandlerSG(gSG);
                pJm.addIf(i == pFrom, pUnmarshallerHandler, (Object)".testGroupParser(new ", (Object)handlerSG.getJavaSource().getQName(), (Object)"(), ", (Object)this.getParamNamespaceURI(), (Object)", ", (Object)this.getParamLocalName(), (Object)", ", (Object)this.getParamQName(), (Object)", ", (Object)this.getParamAttrs(), (Object)")");
                this.acceptParticle(pJm, i);
                pJm.addLine((Object)"return true;");
                continue;
            }
            if (particle.isWildcard()) {
                throw new IllegalStateException("TODO: Add support for wildcards");
            }
            throw new IllegalStateException("Invalid particle type");
        }
        pJm.addEndIf();
    }

    protected abstract int getState(int var1);

    protected abstract DirectAccessible getEndElementState() throws SAXException;

    public JavaMethod newEndElementMethod() throws SAXException {
        JavaMethod result = super.newEndElementMethod();
        JavaQName elementInterface = this.ctSG.getClassContext().getXMLInterfaceName();
        LocalJavaField element = result.newJavaField(elementInterface);
        element.addLine((Object)"(", (Object)elementInterface, (Object)") result");
        result.addSwitch((Object)this.getEndElementState());
        for (int i = 0; i < this.particles.length; ++i) {
            result.addCase((Object)new Integer(this.getState(i)));
            ParticleSG particle = this.particles[i];
            this.handleEndElementState(result, element, particle);
        }
        result.addDefault();
        result.addThrowNew(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = GroupHandlerSG.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, (Object)JavaSource.getQuoted((String)"Illegal state: "), (Object)" + ", (Object)this.getEndElementState());
        result.addEndSwitch();
        return result;
    }

    public JavaMethod newIsFinishedMethod() throws SAXException {
        JavaMethod jm = super.newIsFinishedMethod();
        if (this.isMixed) {
            jm.addLine((Object)"normalize();");
        }
        return jm;
    }

    private void handleEndElementState(JavaMethod pJm, LocalJavaField pElement, ParticleSG pParticle) throws SAXException {
        if (pParticle.isElement()) {
            ObjectSG oSG = pParticle.getObjectSG();
            TypeSG childType = oSG.getTypeSG();
            XsQName name = oSG.getName();
            Object[] uriCondition = "".equals(name.getNamespaceURI()) ? new Object[]{this.getParamNamespaceURI(), " == null  ||  ", this.getParamNamespaceURI(), ".length() == 0"} : new Object[]{JavaSource.getQuoted((String)name.getNamespaceURI()), ".equals(", this.getParamNamespaceURI(), ")"};
            pJm.addIf((Object)uriCondition, (Object)"  &&  ", (Object)JavaSource.getQuoted((String)name.getLocalName()), (Object)".equals(", (Object)this.getParamLocalName(), (Object)")");
            DirectAccessible v = this.getParamResult();
            if (childType.isComplex()) {
                JavaQName type = childType.getComplexTypeSG().getClassContext().getXMLInterfaceName();
                if (this.isMixed) {
                    pJm.addLine((Object)pElement, (Object)".getContent().add(", (Object)v, (Object)");");
                } else {
                    pParticle.getPropertySG().addValue(pJm, (DirectAccessible)pElement, (TypedValue)v, type);
                }
            } else {
                LocalJavaField element;
                PropertySG pSG;
                if (this.isMixed) {
                    LocalJavaField f = pJm.newJavaField(GroupUtil.getContentClass(this.group, pParticle, this.ctSG.getClassContext().getXMLInterfaceName()));
                    f.addLine((Object)"new ", (Object)GroupUtil.getContentClass(this.group, pParticle, this.ctSG.getClassContext().getXMLImplementationName()), (Object)"()");
                    PropertySGChain chain = ((PropertySGImpl)pParticle.getPropertySG()).getHeadOfChain();
                    PropertySGChainImpl head = new PropertySGChainImpl(chain){

                        public String getXMLFieldName(PropertySG pController) throws SAXException {
                            return "_value";
                        }

                        public String getPropertyName(PropertySG pController) throws SAXException {
                            return "value";
                        }
                    };
                    pSG = new PropertySGImpl(head);
                    element = f;
                } else {
                    pSG = pParticle.getPropertySG();
                    element = pElement;
                }
                this.createSimpleTypeConversion(pJm, childType, (TypedValue)v, oSG.getName().toString(), pSG, (DirectAccessible)element);
                if (this.isMixed) {
                    pJm.addLine((Object)pElement, (Object)".getContent().add(", (Object)element, (Object)");");
                }
            }
            pJm.addLine((Object)"return;");
            pJm.addEndIf();
            pJm.addBreak();
        } else if (pParticle.isGroup()) {
            pJm.addThrowNew(class$java$lang$IllegalStateException == null ? (class$java$lang$IllegalStateException = GroupHandlerSG.class$("java.lang.IllegalStateException")) : class$java$lang$IllegalStateException, (Object)JavaSource.getQuoted((String)"This case should be handled by a nested group parser."));
        } else {
            if (pParticle.isWildcard()) {
                throw new IllegalStateException("TODO: Add support for wildcards.");
            }
            throw new IllegalStateException("Invalid particle type");
        }
    }

    public JavaMethod newIsAtomicMethod() throws SAXException {
        return null;
    }

    public JavaMethod newIsEmptyMethod() throws SAXException {
        return null;
    }

    protected JavaMethod newIsMixedMethod() throws SAXException {
        if (!this.isMixed) {
            return null;
        }
        JavaMethod jm = this.getJavaSource().newJavaMethod("isMixed", Boolean.TYPE, JavaSource.PUBLIC);
        jm.addLine((Object)"return true;");
        return jm;
    }

    protected JavaMethod newAddTextMethod() throws SAXException {
        if (!this.isMixed) {
            return null;
        }
        if (this.ccSG != null) {
            return null;
        }
        JavaMethod jm = this.getJavaSource().newJavaMethod("addText", Void.TYPE, JavaSource.PUBLIC);
        Parameter buffer = jm.addParam(array$C == null ? (array$C = GroupHandlerSG.class$("[C")) : array$C, "pBuffer");
        Parameter offset = jm.addParam(Integer.TYPE, "pOffset");
        Parameter length = jm.addParam(Integer.TYPE, "pLength");
        jm.addLine((Object)this.outerHandler.getJavaSource().getQName(), (Object)".this.addText(", (Object)buffer, (Object)", ", (Object)offset, (Object)", ", (Object)length, (Object)");");
        return jm;
    }

    private JavaMethod newContentListMethod() {
        if (!this.isMixed) {
            return null;
        }
        JavaMethod jm = this.getJavaSource().newJavaMethod("getContentList", class$java$util$List == null ? (class$java$util$List = GroupHandlerSG.class$("java.util.List")) : class$java$util$List, JavaSource.PROTECTED);
        JavaQName elementInterface = this.ctSG.getClassContext().getXMLInterfaceName();
        jm.addLine((Object)"return ((", (Object)elementInterface, (Object)") result).getContent();");
        return jm;
    }

    private JavaMethod newGetHandlerMethod(JavaSource pOuter) throws SAXException {
        JavaMethod result = this.getJavaSource().newJavaMethod("getHandler", class$org$apache$ws$jaxme$impl$JMUnmarshallerHandlerImpl == null ? (class$org$apache$ws$jaxme$impl$JMUnmarshallerHandlerImpl = GroupHandlerSG.class$("org.apache.ws.jaxme.impl.JMUnmarshallerHandlerImpl")) : class$org$apache$ws$jaxme$impl$JMUnmarshallerHandlerImpl, JavaSource.PUBLIC);
        result.addLine((Object)"return ", (Object)pOuter.getQName(), (Object)".this.getHandler();");
        return result;
    }

    public void generate() throws SAXException {
        super.generate();
        this.newAddTextMethod();
        this.newIsMixedMethod();
        this.newContentListMethod();
        Iterator iter = this.groups.values().iterator();
        while (iter.hasNext()) {
            HandlerSG handler = (HandlerSG)iter.next();
            handler.generate();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

