/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.ws.jaxme.util.DOMBuilder;
import org.apache.ws.jaxme.util.DOMSerializer;
import org.apache.ws.jaxme.xs.SchemaTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Inliner
implements SchemaTransformer {
    private final Document[] bindings;
    private XMLReader transformedXMLReader;
    private InputSource transformedInputSource;

    public Inliner(Document[] pBindings) {
        this.bindings = pBindings;
    }

    private Document read(InputSource pSource, XMLReader pReader) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        XMLReader xr = spf.newSAXParser().getXMLReader();
        xr.setEntityResolver(pReader.getEntityResolver());
        xr.setErrorHandler(pReader.getErrorHandler());
        DOMBuilder db = new DOMBuilder();
        db.setPrefixMappingIsAttribute(true);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        db.setDocument(doc);
        db.setTarget(doc);
        xr.setContentHandler(db);
        xr.parse(pSource);
        return doc;
    }

    private boolean isURIMatching(String pURI, Element pBindings) {
        Attr schemaLocationAttr = pBindings.getAttributeNodeNS(null, "schemaLocation");
        if (schemaLocationAttr == null) {
            return true;
        }
        String value = schemaLocationAttr.getValue();
        if (value.equals(pURI)) {
            return true;
        }
        if (pURI == null) {
            return false;
        }
        if (pURI.endsWith("/" + value)) {
            return true;
        }
        return !File.separator.equals("/") && pURI.endsWith(File.separator + value);
    }

    private void apply(final Node pTarget, Element pBindings, String pURI) throws XPathExpressionException, SAXException {
        Attr nodeAttr = pBindings.getAttributeNodeNS(null, "node");
        if (!this.isURIMatching(pURI, pBindings)) {
            return;
        }
        if (nodeAttr == null) {
            this.importChilds(pTarget, pBindings, pURI);
        } else {
            XPath xpath = XPathFactory.newInstance().newXPath();
            NamespaceContext ctx = new NamespaceContext(){

                public Iterator getPrefixes(String pURI) {
                    if (pURI == null) {
                        throw new IllegalArgumentException("The URI must not be null.");
                    }
                    if ("http://www.w3.org/XML/1998/namespace".equals(pURI)) {
                        return Collections.singletonList("xml").iterator();
                    }
                    if ("http://www.w3.org/2000/xmlns/".equals(pURI)) {
                        return Collections.singletonList("xmlns").iterator();
                    }
                    List list = this.getPrefixDeclarations(pTarget);
                    ArrayList<String> result = new ArrayList<String>();
                    for (int i = 0; i < list.size(); i += 2) {
                        String prefix;
                        if (!pURI.equals(list.get(i + 1)) || result.contains(prefix = (String)list.get(i))) continue;
                        result.add(prefix);
                    }
                    return result.iterator();
                }

                public String getPrefix(String pURI) {
                    String result = null;
                    Iterator iter = this.getPrefixes(pURI);
                    if (iter.hasNext()) {
                        result = (String)iter.next();
                    } else if ("".equals(pURI)) {
                        result = "";
                    }
                    return result;
                }

                public String getNamespaceURI(String pPrefix) {
                    if (pPrefix == null) {
                        throw new IllegalArgumentException("The prefix must not be null.");
                    }
                    String result = null;
                    if ("xml".equals(pPrefix)) {
                        result = "http://www.w3.org/XML/1998/namespace";
                    } else if ("xmlns".equals(pPrefix)) {
                        result = "http://www.w3.org/2000/xmlns/";
                    } else {
                        List list = this.getPrefixDeclarations(pTarget);
                        for (int i = 0; i < list.size(); i += 2) {
                            if (!pPrefix.equals(list.get(i))) continue;
                            result = (String)list.get(i + 1);
                            break;
                        }
                        if (result == null && pPrefix.equals("")) {
                            result = "";
                        }
                    }
                    return result;
                }

                private List getPrefixDeclarations(Node pTarget2) {
                    ArrayList list = new ArrayList();
                    this.addPrefixDeclarations(pTarget2, list);
                    return list;
                }

                private void addPrefixDeclarations(Node pNode, List pList) {
                    if (pNode == null) {
                        return;
                    }
                    if (pNode.getNodeType() == 1) {
                        Element e = (Element)pNode;
                        if (e.getNamespaceURI() == null || "".equals(e.getNamespaceURI())) {
                            pList.add("");
                            pList.add(e.getPrefix());
                        } else {
                            pList.add(e.getPrefix());
                            pList.add(e.getNamespaceURI());
                        }
                        NamedNodeMap attrs = e.getAttributes();
                        for (int i = 0; i < attrs.getLength(); ++i) {
                            Attr attr = (Attr)attrs.item(i);
                            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                                pList.add(attr.getPrefix());
                                pList.add(attr.getValue());
                                continue;
                            }
                            if (null != attr.getNamespaceURI() || !"xmlns".equals(attr.getLocalName())) continue;
                            pList.add(attr.getLocalName());
                            pList.add(attr.getValue());
                        }
                    }
                    this.addPrefixDeclarations(pNode.getParentNode(), pList);
                }
            };
            xpath.setNamespaceContext(ctx);
            NodeList nodes = (NodeList)xpath.evaluate(nodeAttr.getValue(), pTarget, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !"http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI())) continue;
                this.importChilds(node, pBindings, pURI);
            }
        }
    }

    private void importChilds(Node pTarget, Node pSource, String pURI) throws XPathExpressionException, SAXException {
        Document doc = pTarget.getOwnerDocument();
        Node appInfoElement = null;
        for (Node child = pSource.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            Element e = (Element)child;
            if ("http://java.sun.com/xml/ns/jaxb".equals(e.getNamespaceURI()) && "bindings".equals(e.getLocalName())) {
                this.apply(pTarget, e, pURI);
                continue;
            }
            if (appInfoElement == null) {
                if (pTarget.getNodeType() != 1) {
                    throw new SAXException("Attempt to import childs into a node of type " + pTarget.getNodeType() + ", perhaps invalid XPath expression?");
                }
                Element targetElement = (Element)pTarget;
                String prefix = pTarget.getPrefix();
                Element annotationElement = this.getChild(targetElement, prefix, "annotation");
                appInfoElement = this.getChild(annotationElement, prefix, "appinfo");
            }
            appInfoElement.appendChild(doc.importNode(e, true));
        }
    }

    private Element getChild(Element pParent, String pPrefix, String pName) {
        Element e;
        for (Node child = pParent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !pName.equals((e = (Element)child).getLocalName()) || !"http://www.w3.org/2001/XMLSchema".equals(e.getNamespaceURI())) continue;
            return e;
        }
        String qName = pPrefix == null || pPrefix.length() == 0 ? pName : pPrefix + ":" + pName;
        e = pParent.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", qName);
        pParent.insertBefore(e, pParent.getFirstChild());
        return e;
    }

    public void parse(InputSource pSource, XMLReader pReader) throws ParserConfigurationException, SAXException, IOException {
        String uri = pSource.getSystemId();
        final Document schema = this.read(pSource, pReader);
        try {
            for (int i = 0; i < this.bindings.length; ++i) {
                Element bindingsElement = this.bindings[i].getDocumentElement();
                if (!"http://java.sun.com/xml/ns/jaxb".equals(bindingsElement.getNamespaceURI()) || !"bindings".equals(bindingsElement.getLocalName())) {
                    throw new SAXException("Expected " + new QName("http://java.sun.com/xml/ns/jaxb", "bindings") + " as a binding files root element, got " + new QName(bindingsElement.getNamespaceURI(), bindingsElement.getLocalName()));
                }
                this.apply(schema.getDocumentElement(), bindingsElement, uri);
            }
        }
        catch (XPathExpressionException e) {
            throw new SAXException(e);
        }
        this.transformedInputSource = new InputSource();
        this.transformedXMLReader = new XMLFilterImpl(){

            public void parse(InputSource pInput) throws SAXException, IOException {
                new DOMSerializer().serialize(schema, this);
            }

            public void parse(String pSystemId) throws SAXException, IOException {
                throw new IllegalStateException("Not implemented");
            }
        };
    }

    public InputSource getTransformedInputSource() {
        return this.transformedInputSource;
    }

    public XMLReader getTransformedXMLReader() {
        return this.transformedXMLReader;
    }
}

