/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.XMLCatalog;
import org.apache.ws.jaxme.generator.SchemaReader;
import org.apache.ws.jaxme.generator.impl.GeneratorImpl;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader;
import org.apache.ws.jaxme.generator.sg.impl.JaxMeSchemaReader;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceFactory;
import org.apache.ws.jaxme.js.TextFile;
import org.apache.ws.jaxme.logging.AntProjectLoggerFactory;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.logging.LoggerFactory;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class XJCTask
extends Task {
    private File binding;
    private File schema;
    private File target;
    private File resourceTarget;
    private String packageName;
    private boolean readOnly;
    private boolean extension;
    private boolean removeOldOutput;
    private boolean force;
    private boolean isValidating;
    private boolean isSettingLoggerFactory = true;
    private String stackSize;
    private List bindings = new ArrayList();
    private List schemas = new ArrayList();
    private List depends = new ArrayList();
    private List produces = new ArrayList();
    private List sgFactoryChains = new ArrayList();
    private ClassType schemaReader;
    private List properties = new ArrayList();
    private Dtd dtd;
    private final XMLCatalog xmlCatalog = new XMLCatalog();
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$SchemaReader;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$Generator;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$SGFactoryChain;

    public Property createProperty() {
        Property property = new Property();
        this.properties.add(property);
        return property;
    }

    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    public ClassType createSchemaReader() {
        if (this.schemaReader != null) {
            throw new BuildException("Only one SchemaReader may be configured");
        }
        this.schemaReader = new ClassType();
        return this.schemaReader;
    }

    public SchemaReader getSchemaReader() {
        if (this.schemaReader == null) {
            if (this.isExtension()) {
                return new JaxMeSchemaReader();
            }
            return new JAXBSchemaReader();
        }
        return (SchemaReader)this.schemaReader.getInstance(class$org$apache$ws$jaxme$generator$SchemaReader == null ? (class$org$apache$ws$jaxme$generator$SchemaReader = XJCTask.class$("org.apache.ws.jaxme.generator.SchemaReader")) : class$org$apache$ws$jaxme$generator$SchemaReader);
    }

    public ClassType createSGFactoryChain() {
        ClassType result = new ClassType();
        this.sgFactoryChains.add(result);
        return result;
    }

    public ClassType[] getSGFactoryChains() {
        return this.sgFactoryChains.toArray(new ClassType[this.sgFactoryChains.size()]);
    }

    public String getDescription() {
        return "A JaxMe generator task converting XML schemata into Java source files.";
    }

    public void setValidating(boolean pValidating) {
        this.isValidating = pValidating;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean pForce) {
        this.force = pForce;
    }

    public boolean isSettingLoggerFactory() {
        return this.isSettingLoggerFactory;
    }

    public void setSettingLoggerFactory(boolean pIsSettingLoggerFactory) {
        this.isSettingLoggerFactory = pIsSettingLoggerFactory;
    }

    public File getBinding() {
        return this.binding;
    }

    public void setBinding(File pBinding) {
        this.binding = pBinding;
    }

    public boolean isExtension() {
        return this.extension;
    }

    public void setExtension(boolean pExtension) {
        this.extension = pExtension;
    }

    public String getPackage() {
        return this.packageName;
    }

    public void setPackage(String pPackageName) {
        this.packageName = pPackageName;
    }

    public void setPackageName(String pPackageName) {
        this.log("Warning: The 'packageName' attribute is updated to 'package', for compatibility reasons. Please update your build script.", 1);
        this.setPackage(pPackageName);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean pReadOnly) {
        this.readOnly = pReadOnly;
    }

    public boolean isRemoveOldOutput() {
        return this.removeOldOutput;
    }

    public void setRemoveOldOutput(boolean pRemoveOldOutput) {
        this.removeOldOutput = pRemoveOldOutput;
    }

    public File getSchema() {
        return this.schema;
    }

    public void setSchema(File pSchema) {
        this.schema = pSchema;
    }

    public String getStackSize() {
        return this.stackSize;
    }

    public void setStackSize(String pStackSize) {
        this.stackSize = pStackSize;
        this.log("The 'stackSize' attribute is ignored by the JaxMe ant task.", 1);
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File pTarget) {
        this.target = pTarget;
    }

    public File getResourceTarget() {
        return this.resourceTarget;
    }

    public void setResourceTarget(File pTarget) {
        this.resourceTarget = pTarget;
    }

    public void addSchema(FileSet pSchemas) {
        if (this.getSchema() != null) {
            throw new BuildException("The 'schema' attribute and the nested 'schema' element are mutually exclusive.");
        }
        this.schemas.add(pSchemas);
    }

    public FileSet[] getSchemas() {
        return this.schemas.toArray(new FileSet[this.schemas.size()]);
    }

    public void addBinding(FileSet pBindings) {
        if (this.getBinding() != null) {
            throw new BuildException("The 'binding' attribute and the nested 'binding' element are mutually exclusive.");
        }
        this.bindings.add(pBindings);
    }

    public FileSet[] getBindings() {
        return this.bindings.toArray(new FileSet[this.bindings.size()]);
    }

    public void addClasspath(Path pClasspath) {
        this.log("The 'classpath' attribute is ignored by the JaxMe ant task.", 1);
    }

    public void addArg(Commandline.Argument pArg) {
        this.log("The 'arg' attribute is ignored by the JaxMe ant task.", 1);
    }

    public void addDepends(FileSet pDepends) {
        this.depends.add(pDepends);
    }

    public FileSet[] getDepends() {
        return this.depends.toArray(new FileSet[this.depends.size()]);
    }

    public FileSet createProduces() {
        FileSet result = new FileSet();
        this.produces.add(result);
        return result;
    }

    public FileSet[] getProduces() {
        return this.produces.toArray(new FileSet[this.produces.size()]);
    }

    public Dtd createDtd() {
        if (this.dtd == null) {
            this.dtd = new Dtd();
            return this.dtd;
        }
        throw new BuildException("Multiple nested 'dtd' elements are forbidden.", this.getLocation());
    }

    public Dtd getDtd() {
        return this.dtd;
    }

    public void finish() {
        if (this.getSchema() == null && this.getSchemas().length == 0) {
            throw new BuildException("Either of the 'schema' attribute or the nested 'schema' elements must be given.", this.getLocation());
        }
    }

    private File[] getFiles(FileSet[] pFileSets) {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < pFileSets.length; ++i) {
            FileSet fileSet = pFileSets[i];
            DirectoryScanner scanner = fileSet.getDirectoryScanner(this.getProject());
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            for (int j = 0; j < files.length; ++j) {
                list.add(new File(fileSet.getDir(this.getProject()), files[j]));
            }
        }
        return list.toArray(new File[list.size()]);
    }

    private File[] getSchemaFiles() {
        if (this.getSchema() != null) {
            return new File[]{this.getSchema()};
        }
        return this.getFiles(this.getSchemas());
    }

    private File[] getBindingFiles() {
        if (this.getBinding() != null) {
            return new File[]{this.getBinding()};
        }
        return this.getFiles(this.getBindings());
    }

    private File[] getDependsFiles() {
        return this.getFiles(this.getDepends());
    }

    public boolean isUpToDate(File[] pSchemaFiles, File[] pBindingFiles, File[] pDependsFiles, List pProducesList) {
        int i;
        long l;
        File f;
        FileSet[] myProduces = this.getProduces();
        if (myProduces.length == 0) {
            this.log("No nested 'produces' elements, up-to-date check returns false", 3);
            return false;
        }
        boolean result = true;
        long firstTarget = 0L;
        File firstTargetFile = null;
        for (int i2 = 0; i2 < myProduces.length; ++i2) {
            File dir = myProduces[i2].getDir(this.getProject());
            if (dir == null) {
                dir = this.getTarget();
                if (dir == null) {
                    dir = this.getProject().getBaseDir();
                }
                myProduces[i2].setDir(dir);
            }
            if (!dir.exists()) {
                this.log("The directory specified by the nested 'produces' element #" + i2 + " does not exist, up-to-date check returns false", 3);
                result = false;
                continue;
            }
            DirectoryScanner scanner = myProduces[i2].getDirectoryScanner(this.getProject());
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            if (files.length == 0) {
                this.log("The fileset specified by the nested 'produces' element #" + i2 + " is empty, up-to-date check returns false", 3);
                result = false;
            }
            for (int j = 0; j < files.length; ++j) {
                f = new File(dir, files[j]).getAbsoluteFile();
                if (pProducesList != null) {
                    pProducesList.add(f);
                }
                if ((l = f.lastModified()) == -1L) {
                    this.log("Unable to determine timestamp of target file " + f + ", up-to-date check returns false.", 3);
                    result = false;
                }
                if (firstTargetFile != null && firstTarget <= l) continue;
                firstTargetFile = f;
                firstTarget = l;
            }
        }
        if (this.isForce()) {
            this.log("Force option is set, up-to-date check returns false", 3);
            result = false;
        }
        if (!result) {
            return false;
        }
        ArrayList<File> sourceFiles = new ArrayList<File>();
        for (i = 0; i < pSchemaFiles.length; ++i) {
            sourceFiles.add(pSchemaFiles[i]);
        }
        for (i = 0; i < pBindingFiles.length; ++i) {
            sourceFiles.add(pBindingFiles[i]);
        }
        for (i = 0; i < pDependsFiles.length; ++i) {
            sourceFiles.add(pDependsFiles[i]);
        }
        long lastSource = 0L;
        File lastSourceFile = null;
        Iterator iter = sourceFiles.iterator();
        while (iter.hasNext()) {
            f = (File)iter.next();
            l = f.lastModified();
            if (l == -1L) {
                this.log("Unable to determine timestamp of source file " + f + ", up-to-date check returns false.", 3);
                result = false;
            }
            if (lastSourceFile != null && lastSource >= l) continue;
            lastSource = l;
            lastSourceFile = f;
        }
        if (lastSourceFile == null) {
            this.log("No source files found, up-to-date check returns false.", 3);
            return false;
        }
        if (!result) {
            return false;
        }
        try {
            long l2;
            URL url = (class$org$apache$ws$jaxme$generator$Generator == null ? (class$org$apache$ws$jaxme$generator$Generator = XJCTask.class$("org.apache.ws.jaxme.generator.Generator")) : class$org$apache$ws$jaxme$generator$Generator).getClassLoader().getResource((class$org$apache$ws$jaxme$generator$Generator == null ? (class$org$apache$ws$jaxme$generator$Generator = XJCTask.class$("org.apache.ws.jaxme.generator.Generator")) : class$org$apache$ws$jaxme$generator$Generator).getName().replace('.', '/') + ".class");
            if (url != null && (l2 = url.openConnection().getLastModified()) != 0L && lastSource < l2) {
                this.log("Generator class is newer than any schema files, using Generator classes timestamp as schema timestamp.", 4);
                lastSource = l2;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (lastSource >= firstTarget) {
            this.log("Source file " + lastSourceFile + " is more recent than target file " + firstTargetFile + ", up-to-date check returns false", 3);
            return false;
        }
        this.log("All target files are up-to-date.", 3);
        return true;
    }

    public void stopLogging(LoggerFactory pFactory) {
        if (pFactory != null) {
            LoggerAccess.setLoggerFactory((LoggerFactory)pFactory);
        }
    }

    public LoggerFactory initLogging() {
        if (!this.isSettingLoggerFactory()) {
            return null;
        }
        LoggerFactory loggerFactory = LoggerAccess.getLoggerFactory();
        if (!(loggerFactory instanceof AntProjectLoggerFactory)) {
            loggerFactory = new AntProjectLoggerFactory((Task)this);
            LoggerAccess.setLoggerFactory((LoggerFactory)loggerFactory);
            return loggerFactory;
        }
        return null;
    }

    public void init() {
        super.init();
        this.xmlCatalog.setProject(this.getProject());
    }

    public void addConfiguredXMLCatalog(XMLCatalog pXmlCatalog) {
        this.xmlCatalog.addConfiguredXMLCatalog(pXmlCatalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        MyClassLoader cl = new MyClassLoader(parent == null ? ((Object)((Object)this)).getClass().getClassLoader() : parent);
        LoggerFactory loggerFactory = this.initLogging();
        try {
            int i;
            Dtd myDtd;
            ArrayList producesFiles;
            Thread.currentThread().setContextClassLoader(cl);
            File[] schemaFiles = this.getSchemaFiles();
            if (schemaFiles.length == 0) {
                this.log("No schema files specified", 1);
                return;
            }
            File[] bindingFiles = this.getBindingFiles();
            File[] dependFiles = this.getDependsFiles();
            ArrayList arrayList = producesFiles = this.isRemoveOldOutput() ? new ArrayList() : null;
            if (this.isUpToDate(schemaFiles, bindingFiles, dependFiles, producesFiles)) {
                return;
            }
            HashSet<File> producesFilesSet = null;
            if (producesFiles != null) {
                producesFilesSet = new HashSet<File>();
                Iterator iter = producesFiles.iterator();
                while (iter.hasNext()) {
                    File f = (File)iter.next();
                    producesFilesSet.add(f);
                }
            }
            GeneratorImpl generator = new GeneratorImpl();
            generator.setEntityResolver((EntityResolver)this.xmlCatalog);
            generator.setForcingOverwrite(this.isForce());
            generator.setSettingReadOnly(this.isReadOnly());
            generator.setValidating(this.isValidating());
            for (int i2 = 0; i2 < bindingFiles.length; ++i2) {
                try {
                    String systemId = bindingFiles[i2].toURL().toExternalForm();
                    generator.addBindings(new InputSource(systemId));
                    continue;
                }
                catch (Exception e) {
                    throw new BuildException("Failed to read external binding file " + bindingFiles[i2] + ": " + e.getMessage(), (Throwable)e, this.getLocation());
                }
            }
            if (this.getPackage() != null) {
                generator.setProperty("jaxme.package.name", this.getPackage());
            }
            if ((myDtd = this.getDtd()) != null) {
                generator.setProperty("jaxme.dtd.input", "true");
                if (myDtd.getTargetNamespace() != null) {
                    generator.setProperty("jaxme.dtd.targetNamespace", myDtd.getTargetNamespace());
                }
            }
            Property[] myProperties = this.getProperties();
            for (int i3 = 0; i3 < myProperties.length; ++i3) {
                Property ot = myProperties[i3];
                this.log("Option " + ot.getName() + "=" + ot.getValue(), 3);
                generator.setProperty(ot.getName(), ot.getValue());
            }
            SchemaReader reader = this.getSchemaReader();
            if (reader instanceof JAXBSchemaReader) {
                ((JAXBSchemaReader)reader).setSupportingExtensions(this.isExtension());
            }
            generator.setSchemaReader(reader);
            reader.setGenerator(generator);
            generator.setTargetDirectory(this.getTarget());
            generator.setResourceTargetDirectory(this.getResourceTarget());
            ClassType[] mySgFactoryChains = this.getSGFactoryChains();
            if (mySgFactoryChains.length > 0) {
                if (!(reader instanceof JAXBSchemaReader)) {
                    throw new BuildException("The nested child element 'sgFactoryChain' is valid only, if the schema reader is an instance of " + (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader = XJCTask.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader).getName(), this.getLocation());
                }
                for (i = 0; i < mySgFactoryChains.length; ++i) {
                    Class<?> c;
                    ClassType ct = mySgFactoryChains[i];
                    try {
                        c = cl.loadClass(ct.getClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new BuildException("Failed to load SGFactoryChain implementation class " + ct.getClassName(), this.getLocation());
                    }
                    if (!(class$org$apache$ws$jaxme$generator$sg$SGFactoryChain == null ? XJCTask.class$("org.apache.ws.jaxme.generator.sg.SGFactoryChain") : class$org$apache$ws$jaxme$generator$sg$SGFactoryChain).isAssignableFrom(c)) {
                        throw new BuildException("The SGFactoryChain class " + c.getName() + " is not implementing " + (class$org$apache$ws$jaxme$generator$sg$SGFactoryChain == null ? (class$org$apache$ws$jaxme$generator$sg$SGFactoryChain = XJCTask.class$("org.apache.ws.jaxme.generator.sg.SGFactoryChain")) : class$org$apache$ws$jaxme$generator$sg$SGFactoryChain).getName(), this.getLocation());
                    }
                    reader.addSGFactoryChain(c);
                }
            }
            for (i = 0; i < schemaFiles.length; ++i) {
                String msg;
                this.log("Reading schema file " + schemaFiles[i], 3);
                try {
                    File f;
                    SchemaSG schemaSG = generator.generate(schemaFiles[i]);
                    if (producesFilesSet == null) continue;
                    JavaSourceFactory jsf = schemaSG.getJavaSourceFactory();
                    File targetDirectory = this.getTarget();
                    Iterator iter = jsf.getJavaSources();
                    while (iter.hasNext()) {
                        JavaSource js = (JavaSource)iter.next();
                        f = jsf.getLocation(targetDirectory, js).getAbsoluteFile();
                        producesFilesSet.remove(f);
                    }
                    iter = jsf.getTextFiles();
                    while (iter.hasNext()) {
                        TextFile tf = (TextFile)iter.next();
                        f = jsf.getLocation(targetDirectory, tf).getAbsoluteFile();
                        producesFilesSet.remove(f);
                    }
                    continue;
                }
                catch (SAXParseException e) {
                    msg = LocSAXException.formatMsg((String)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()), (String)e.getPublicId(), (String)e.getSystemId(), (int)e.getLineNumber(), (int)e.getColumnNumber());
                    throw new BuildException(msg, (Throwable)e, this.getLocation());
                }
                catch (Exception e) {
                    msg = e.getMessage();
                    if (msg == null) {
                        msg = e.getClass().getName();
                    }
                    throw new BuildException(schemaFiles[i] + ": " + msg, (Throwable)e, this.getLocation());
                }
            }
            if (producesFilesSet != null) {
                Iterator iter = producesFilesSet.iterator();
                while (iter.hasNext()) {
                    File f = (File)iter.next();
                    this.log("Removing orphan file " + f, 3);
                    if (f.delete()) continue;
                    throw new BuildException("Unable to delete file " + f);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(parent);
            this.stopLogging(loggerFactory);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class MyClassLoader
    extends ClassLoader {
        private ClassLoader parent;

        public ClassLoader getMyParent() {
            return this.parent;
        }

        public MyClassLoader(ClassLoader pParent) {
            super(((Object)((Object)XJCTask.this)).getClass().getClassLoader());
            this.parent = pParent;
        }

        public Class findClass(String name) throws ClassNotFoundException {
            return this.parent.loadClass(name);
        }

        public URL findResource(String resource) {
            return this.parent.getResource(resource);
        }

        public Enumeration findResources(String resource) throws IOException {
            return this.parent.getResources(resource);
        }
    }

    public static class ClassType {
        private String className;

        public void setClassName(String pClassName) {
            this.className = pClassName;
        }

        public String getClassName() {
            return this.className;
        }

        public Object getInstance(Class pInstanceClass) {
            Class cl;
            if (this.className == null) {
                throw new NullPointerException("Missing attribute: 'class'");
            }
            try {
                cl = org.apache.ws.jaxme.util.ClassLoader.getClass(this.className, pInstanceClass);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException("Could not load class " + this.className, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new BuildException((Throwable)e);
            }
            try {
                return cl.newInstance();
            }
            catch (Exception e) {
                throw new BuildException("The class " + this.className + " could not be instantiated: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static class Property {
        private String name;
        private String value;

        public void setName(String pName) {
            this.name = pName;
        }

        public void setValue(String pValue) {
            this.value = pValue;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public void finish() {
            if (this.name == null) {
                throw new NullPointerException("Missing attribute: 'name'");
            }
            if (this.value == null) {
                throw new NullPointerException("Missing attribute: 'value'");
            }
        }
    }

    public static class Dtd {
        private String targetNamespace;

        public void setTargetNamespace(String pTargetNamespace) {
            this.targetNamespace = pTargetNamespace;
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }
    }
}

