/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.dom.DOMUtil;
import org.apache.axiom.om.impl.dom.LeafNode;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;

public abstract class CharacterImpl
extends LeafNode
implements CharacterData,
OMNodeEx {
    protected String textValue;

    protected CharacterImpl(OMFactory factory) {
        super(factory);
    }

    public CharacterImpl(String value, OMFactory factory) {
        super(factory);
        this.textValue = value != null ? value : "";
    }

    public void appendData(String value) throws DOMException {
        this.textValue = this.textValue + value;
    }

    public void deleteData(int offset, int count) throws DOMException {
        this.replaceData(offset, count, null);
    }

    public void replaceData(int offset, int count, String data) throws DOMException {
        int length = this.textValue.length();
        if (offset < 0 || offset > length - 1 || count < 0) {
            throw DOMUtil.newDOMException((short)1);
        }
        int end = Math.min(count + offset, length);
        this.textValue = data == null ? new StringBuilder(this.textValue).delete(offset, end).toString() : new StringBuilder(this.textValue).replace(offset, end, data).toString();
    }

    public String getData() throws DOMException {
        return this.textValue != null ? this.textValue : "";
    }

    public void insertData(int offset, String data) throws DOMException {
        int length = this.getLength();
        if (offset < 0 || offset > length - 1) {
            throw DOMUtil.newDOMException((short)1);
        }
        this.textValue = new StringBuilder(this.textValue).insert(offset, data).toString();
    }

    public void setData(String data) throws DOMException {
        this.textValue = data;
    }

    public String substringData(int offset, int count) throws DOMException {
        if (offset < 0 || offset > this.getLength() || count < 0) {
            throw DOMUtil.newDOMException((short)1);
        }
        int end = Math.min(count + offset, this.textValue.length());
        return this.textValue.substring(offset, end);
    }

    public int getLength() {
        return this.textValue != null ? this.textValue.length() : 0;
    }
}

