/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.image.resource;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.WebResource;
import org.apache.wicket.markup.html.image.resource.DynamicImageResource;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailImageResource
extends DynamicImageResource {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)ThumbnailImageResource.class);
    private final WebResource unscaledImageResource;
    private final int maxSize;
    private int scaleHints = 4;
    private transient byte[] thumbnail;

    public ThumbnailImageResource(WebResource unscaledImageResource, int maxSize) {
        if (unscaledImageResource == null) {
            throw new IllegalArgumentException("Argument unscaledImageResource must be not null");
        }
        this.unscaledImageResource = unscaledImageResource;
        this.maxSize = maxSize;
    }

    protected byte[] getImageData() {
        if (this.thumbnail == null) {
            BufferedImage image = this.getScaledImageInstance();
            this.thumbnail = this.toImageData(image);
            this.setLastModifiedTime(Time.now());
        }
        return this.thumbnail;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final BufferedImage getScaledImageInstance() {
        block12: {
            is = null;
            originalImage = null;
            try {
                is = this.unscaledImageResource.getResourceStream().getInputStream();
                originalImage = ImageIO.read(is);
                if (originalImage == null) {
                    throw new IOException("unable to read image");
                }
                var5_3 = null;
                if (is == null) break block12;
                ** GOTO lbl26
            }
            catch (IOException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            catch (ResourceStreamNotFoundException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
            {
                catch (Throwable var4_12) {
                    var5_4 = null;
                    if (is == null) throw var4_12;
                    try {
                        is.close();
                        throw var4_12;
                    }
                    catch (IOException e) {
                        ThumbnailImageResource.log.error(e.getMessage(), (Throwable)e);
                    }
                    throw var4_12;
                }
lbl26:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 76->83)] { 
lbl27:
                // 1 sources

                is.close();
lbl29:
                // 1 sources

                catch (IOException e) {}
                ThumbnailImageResource.log.error(e.getMessage(), (Throwable)e);
            }
        }
        originalWidth = originalImage.getWidth();
        originalHeight = originalImage.getHeight();
        if (originalWidth <= this.maxSize) {
            if (originalHeight <= this.maxSize) return originalImage;
        }
        if (originalWidth > originalHeight) {
            newWidth = this.maxSize;
            newHeight = this.maxSize * originalHeight / originalWidth;
        } else {
            newWidth = this.maxSize * originalWidth / originalHeight;
            newHeight = this.maxSize;
        }
        image = originalImage.getScaledInstance(newWidth, newHeight, this.scaleHints);
        bufferedImage = new BufferedImage(newWidth, newHeight, 2);
        bufferedImage.createGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public final synchronized void setScaleHints(int scaleHints) {
        this.scaleHints = scaleHints;
        this.invalidate();
    }

    public synchronized void invalidate() {
        this.thumbnail = null;
    }
}

