/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.autocomplete;

import java.util.Iterator;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.StringAutoCompleteRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;

public abstract class AutoCompleteTextField
extends TextField {
    private static final long serialVersionUID = 1L;

    public AutoCompleteTextField(String id, Class type) {
        this(id, null, type, false);
    }

    public AutoCompleteTextField(String id, IModel model, Class type, boolean preselect) {
        this(id, model, type, StringAutoCompleteRenderer.INSTANCE, preselect);
    }

    public AutoCompleteTextField(String id, IModel object, boolean preselect) {
        this(id, object, null, preselect);
    }

    public AutoCompleteTextField(String id, IModel object) {
        this(id, object, null, false);
    }

    public AutoCompleteTextField(String id, boolean preselect) {
        this(id, (IModel)null, preselect);
    }

    public AutoCompleteTextField(String id) {
        this(id, (IModel)null, false);
    }

    public AutoCompleteTextField(String id, IAutoCompleteRenderer renderer) {
        this(id, (IModel)null, renderer);
    }

    public AutoCompleteTextField(String id, Class type, IAutoCompleteRenderer renderer) {
        this(id, null, type, renderer, false);
    }

    public AutoCompleteTextField(String id, IModel model, IAutoCompleteRenderer renderer) {
        this(id, model, null, renderer, false);
    }

    public AutoCompleteTextField(String id, IModel model, Class type, IAutoCompleteRenderer renderer, boolean preselect) {
        super(id, model, type);
        this.add((IBehavior)new SimpleAttributeModifier("autocomplete", (CharSequence)"off"));
        this.add((IBehavior)new AutoCompleteBehavior(renderer, preselect){
            private static final long serialVersionUID = 1L;

            protected Iterator getChoices(String input) {
                return AutoCompleteTextField.this.getChoices(input);
            }
        });
    }

    protected abstract Iterator getChoices(String var1);
}

