/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.validation.IErrorMessageSource;
import org.apache.wicket.validation.IValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationError
implements IValidationError {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Object> EMPTY_VARS = Collections.emptyMap();
    private final List<String> keys = new ArrayList<String>(1);
    private Map<String, Object> vars;
    private String message;

    public ValidationError addMessageKey(String key) {
        if (key == null || key.trim().length() == 0) {
            throw new IllegalArgumentException("Argument [[key]] cannot be null or an empty string");
        }
        this.keys.add(key);
        return this;
    }

    public ValidationError setVariable(String name, Object value) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("Argument [[name]] cannot be null or an empty string");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument [[value]] cannot be null or an empty string");
        }
        this.getVariables().put(name, value);
        return this;
    }

    public final Map<String, Object> getVariables() {
        if (this.vars == null) {
            this.vars = new HashMap<String, Object>(2);
        }
        return this.vars;
    }

    public final ValidationError setVariables(Map<String, Object> vars) {
        if (vars == null) {
            throw new IllegalArgumentException("Argument `vars` cannot be null");
        }
        this.vars = vars;
        return this;
    }

    @Override
    public final String getErrorMessage(IErrorMessageSource messageSource) {
        String key;
        String errorMessage = null;
        Iterator<String> i$ = this.keys.iterator();
        while (i$.hasNext() && (errorMessage = messageSource.getMessage(key = i$.next())) == null) {
        }
        if (errorMessage == null && this.message != null) {
            errorMessage = this.message;
        }
        if (errorMessage != null) {
            Map<String, Object> p = this.vars != null ? this.vars : EMPTY_VARS;
            errorMessage = messageSource.substitute(errorMessage, p);
        }
        return errorMessage;
    }

    public final String getMessage() {
        return this.message;
    }

    public final ValidationError setMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument [[defaultMessage]] cannot be null");
        }
        this.message = message;
        return this;
    }

    public List<String> getKeys() {
        if (this.keys == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.keys);
    }

    public String toString() {
        Iterator<Object> i;
        StringBuilder tostring = new StringBuilder();
        tostring.append("[").append(Classes.simpleName(this.getClass()));
        tostring.append(" message=[").append(this.message);
        tostring.append("], keys=[");
        if (this.keys != null) {
            i = this.keys.iterator();
            while (i.hasNext()) {
                tostring.append(i.next());
                if (!i.hasNext()) continue;
                tostring.append(", ");
            }
        } else {
            tostring.append("null");
        }
        tostring.append("], variables=[");
        if (this.vars != null) {
            i = this.vars.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                tostring.append("[").append((String)e.getKey()).append("=").append(e.getValue()).append("]");
                if (!i.hasNext()) continue;
                tostring.append(",");
            }
        } else {
            tostring.append("null");
        }
        tostring.append("]");
        tostring.append("]");
        return tostring.toString();
    }
}

