/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundValidator<T>
extends Behavior
implements IValidator<T> {
    private static final long serialVersionUID = 1L;
    private final List<IValidator<T>> validators = new ArrayList<IValidator<T>>(2);

    public final CompoundValidator<T> add(IValidator<T> validator) {
        if (validator == null) {
            throw new IllegalArgumentException("Argument `validator` cannot be null");
        }
        this.validators.add(validator);
        return this;
    }

    @Override
    public final void validate(IValidatable<T> validatable) {
        Iterator<IValidator<T>> it = this.validators.iterator();
        while (it.hasNext() && validatable.isValid()) {
            it.next().validate(validatable);
        }
    }

    public final List<IValidator<T>> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }
}

