/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.tester;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import junit.framework.Assert;
import org.apache.wicket.markup.MarkupParser;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.DifferentiationFailedException;
import org.apache.wicket.util.diff.Revision;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.StringList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffUtil {
    private static final Logger log = LoggerFactory.getLogger(DiffUtil.class);
    private static final String ENCODING = "UTF-8";

    public static final void replaceExpectedResultFile(String document, Class<?> clazz, String file) throws IOException {
        String filename = clazz.getPackage().getName();
        filename = filename.replace('.', '/');
        filename = filename + "/" + file;
        URL url = clazz.getClassLoader().getResource(filename);
        filename = url.getFile();
        filename = filename.replaceAll("/target/test-classes/", "/src/test/java/");
        PrintWriter out = new PrintWriter(new FileOutputStream(filename));
        out.print(document);
        out.close();
    }

    public static final boolean validatePage(String document, Class<?> clazz, String file, boolean failWithAssert) throws IOException {
        Args.notNull((Object)document, (String)"document");
        String filename = clazz.getPackage().getName();
        filename = filename.replace('.', '/');
        filename = filename + "/" + file;
        InputStream in = clazz.getClassLoader().getResourceAsStream(filename);
        if (in == null) {
            throw new IOException("File not found: " + filename);
        }
        String reference = Streams.readString((InputStream)in, (CharSequence)ENCODING);
        reference = reference.replaceAll("\n\r", "\n");
        reference = reference.replaceAll("\r\n", "\n");
        document = document.replaceAll("\n\r", "\n");
        boolean equals = DiffUtil.compareMarkup(document = document.replaceAll("\r\n", "\n"), reference);
        if (!equals) {
            if (Boolean.getBoolean("wicket.replace.expected.results")) {
                in.close();
                in = null;
                DiffUtil.replaceExpectedResultFile(document, clazz, file);
                return true;
            }
            log.error("File name: " + file);
            log.error("===================");
            log.error(reference);
            log.error("===================");
            log.error(document);
            log.error("===================");
            Object[] test1 = StringList.tokenize((String)reference, (String)"\n").toArray();
            Object[] test2 = StringList.tokenize((String)document, (String)"\n").toArray();
            Diff df = new Diff(test1);
            try {
                Revision r = df.diff(test2);
            }
            catch (DifferentiationFailedException e) {
                throw new RuntimeException(e);
            }
            if (failWithAssert) {
                Assert.assertEquals((String)filename, (String)reference, (String)document);
            }
        }
        return equals;
    }

    private static boolean compareMarkup(String a, String b) {
        try {
            MarkupStream amarkup = new MarkupStream(new MarkupParser(a).parse());
            MarkupStream bmarkup = new MarkupStream(new MarkupParser(b).parse());
            return amarkup.equalTo(bmarkup);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ResourceStreamNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

