/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Iterator;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionResourceNameIterator
implements Iterator<String> {
    private final String[] extensions;
    private int index;

    public ExtensionResourceNameIterator(String extension, char separatorChar) {
        String[] extensions = Strings.split((String)extension, (char)separatorChar);
        if (extensions.length == 0) {
            extensions = new String[]{""};
        }
        this.extensions = extensions;
        this.index = 0;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.extensions.length;
    }

    @Override
    public String next() {
        String rtn;
        return (rtn = this.extensions[this.index++].trim()).startsWith(".") ? rtn.substring(1) : rtn;
    }

    public final String getExtension() {
        String rtn = this.extensions[this.index - 1].trim();
        return rtn.startsWith(".") ? rtn.substring(1) : rtn;
    }

    @Override
    public void remove() {
    }
}

