/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;

public class WebExternalResourceStream
extends AbstractResourceStream {
    private static final long serialVersionUID = 1L;
    transient InputStream in;
    private final String url;

    public WebExternalResourceStream(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Argument url must be not null");
        }
        this.url = url;
    }

    public Bytes length() {
        return null;
    }

    public void close() throws IOException {
        IOUtils.close((Closeable)this.in);
    }

    public Time lastModifiedTime() {
        return Time.now();
    }

    public String getContentType() {
        return WebApplication.get().getServletContext().getMimeType(this.url);
    }

    public InputStream getInputStream() throws ResourceStreamNotFoundException {
        ServletContext context = ((WebApplication)Application.get()).getServletContext();
        this.in = context.getResourceAsStream(this.url);
        if (this.in == null) {
            throw new ResourceStreamNotFoundException("The requested resource was not found: " + this.url);
        }
        return this.in;
    }
}

