/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.cookies;

import javax.servlet.http.Cookie;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.cookies.CookieDefaults;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieUtils {
    private static final Logger log = LoggerFactory.getLogger(CookieUtils.class);
    private final CookieDefaults settings;

    public CookieUtils() {
        this.settings = new CookieDefaults();
    }

    public CookieUtils(CookieDefaults settings) {
        this.settings = settings;
    }

    public final CookieDefaults getSettings() {
        return this.settings;
    }

    public final void remove(String key) {
        Cookie cookie = this.getCookie(key);
        if (cookie != null) {
            this.remove(cookie);
        }
    }

    public final void remove(FormComponent<?> formComponent) {
        this.remove(this.getKey(formComponent));
    }

    protected String getKey(FormComponent<?> component) {
        return component.getPageRelativePath();
    }

    public final String load(String key) {
        Cookie cookie = this.getCookie(key);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public final String load(FormComponent<?> formComponent) {
        String value = this.load(this.getKey(formComponent));
        if (value != null) {
            formComponent.setModelValue(this.splitValue(value));
        }
        return value;
    }

    protected String[] splitValue(String value) {
        return value.split(FormComponent.VALUE_SEPARATOR);
    }

    protected String joinValues(String ... values) {
        return Strings.join((String)FormComponent.VALUE_SEPARATOR, (String[])values);
    }

    public final void save(String key, String ... values) {
        key = this.getSaveKey(key);
        String value = this.joinValues(values);
        Cookie cookie = this.getCookie(key);
        if (cookie == null) {
            cookie = new Cookie(key, value);
        } else {
            cookie.setValue(value);
        }
        cookie.setSecure(false);
        cookie.setMaxAge(this.settings.getMaxAge());
        this.save(cookie);
    }

    public final void save(FormComponent<?> formComponent) {
        this.save(this.getKey(formComponent), formComponent.getValue());
    }

    protected String getSaveKey(String key) {
        if (Strings.isEmpty((CharSequence)key)) {
            throw new IllegalArgumentException("A Cookie name can not be null or empty");
        }
        key = key.replace(".", "..");
        key = key.replace(":", ".");
        return key;
    }

    private void remove(Cookie cookie) {
        if (cookie != null) {
            cookie.setMaxAge(0);
            cookie.setValue(null);
            this.save(cookie);
            if (log.isDebugEnabled()) {
                log.debug("Removed Cookie: " + cookie.getName());
            }
        }
    }

    private Cookie getCookie(String name) {
        String key = this.getSaveKey(name);
        try {
            Cookie cookie = this.getWebRequest().getCookie(key);
            if (log.isDebugEnabled()) {
                if (cookie != null) {
                    log.debug("Found Cookie with name=" + key + " and request URI=" + this.getWebRequest().getUrl().toString());
                } else {
                    log.debug("Unable to find Cookie with name=" + key + " and request URI=" + this.getWebRequest().getUrl().toString());
                }
            }
            return cookie;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    private Cookie save(Cookie cookie) {
        if (cookie == null) {
            return null;
        }
        this.initializeCookie(cookie);
        this.getWebResponse().addCookie(cookie);
        if (log.isDebugEnabled()) {
            log.debug("Cookie saved: " + this.cookieToDebugString(cookie) + "; request URI=" + this.getWebRequest().getUrl().toString());
        }
        return cookie;
    }

    protected void initializeCookie(Cookie cookie) {
        String domain;
        String comment = this.settings.getComment();
        if (comment != null) {
            cookie.setComment(comment);
        }
        if ((domain = this.settings.getDomain()) != null) {
            cookie.setDomain(domain);
        }
        ServletWebRequest request = (ServletWebRequest)this.getWebRequest();
        String path = request.getContainerRequest().getContextPath() + "/" + request.getFilterPrefix();
        cookie.setPath(path);
        cookie.setVersion(this.settings.getVersion());
        cookie.setSecure(this.settings.getSecure());
    }

    private WebRequest getWebRequest() {
        return (WebRequest)RequestCycle.get().getRequest();
    }

    private WebResponse getWebResponse() {
        return (WebResponse)RequestCycle.get().getResponse();
    }

    private String cookieToDebugString(Cookie cookie) {
        return "[Cookie  name = " + cookie.getName() + ", value = " + cookie.getValue() + ", domain = " + cookie.getDomain() + ", path = " + cookie.getPath() + ", maxAge = " + Time.millis((long)cookie.getMaxAge()).toDateString() + "(" + cookie.getMaxAge() + ")" + "]";
    }
}

