/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.settings.def;

import java.io.File;
import java.io.IOException;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.settings.IStoreSettings;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;

public class StoreSettings
implements IStoreSettings {
    private static final int DEFAULT_CACHE_SIZE = 40;
    private static final int DEFAULT_FILE_CHANNEL_POOL_CAPACITY = 50;
    private static final Bytes DEFAULT_MAX_SIZE_PER_SESSION = Bytes.megabytes((long)10L);
    private static final int DEFAULT_ASYNCHRONOUS_QUEUE_CAPACITY = 100;
    private int fileChannelPoolCapacity = 50;
    private int inmemoryCacheSize = 40;
    private Bytes maxSizePerSession = DEFAULT_MAX_SIZE_PER_SESSION;
    private File fileStoreFolder = null;
    private int asynchronousQueueCapacity = 100;

    public StoreSettings(Application application) {
    }

    public int getFileChannelPoolCapacity() {
        return this.fileChannelPoolCapacity;
    }

    public void setFileChannelPoolCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("File channel pool capacity must be a positive number.");
        }
        this.fileChannelPoolCapacity = capacity;
    }

    public int getInmemoryCacheSize() {
        return this.inmemoryCacheSize;
    }

    public void setInmemoryCacheSize(int inmemoryCacheSize) {
        this.inmemoryCacheSize = inmemoryCacheSize;
    }

    public Bytes getMaxSizePerSession() {
        return this.maxSizePerSession;
    }

    public void setMaxSizePerSession(Bytes maxSizePerSession) {
        this.maxSizePerSession = (Bytes)Args.notNull((Object)maxSizePerSession, (String)"maxSizePerSession");
    }

    public File getFileStoreFolder() {
        if (this.fileStoreFolder == null) {
            if (Application.exists()) {
                this.fileStoreFolder = (File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir");
            }
            if (this.fileStoreFolder != null) {
                return this.fileStoreFolder;
            }
            try {
                this.fileStoreFolder = File.createTempFile("file-prefix", null).getParentFile();
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        }
        return this.fileStoreFolder;
    }

    public void setFileStoreFolder(File fileStoreFolder) {
        this.fileStoreFolder = (File)Args.notNull((Object)fileStoreFolder, (String)"fileStoreFolder");
    }

    public int getAsynchronousQueueCapacity() {
        return this.asynchronousQueueCapacity;
    }

    public void setAsynchronousQueueCapacity(int queueCapacity) {
        if (queueCapacity < 1) {
            throw new IllegalArgumentException("The capacity of the asynchronous queue should be at least 1.");
        }
        this.asynchronousQueueCapacity = queueCapacity;
    }
}

