/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.session;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.wicket.IPageFactory;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.request.RequestHandlerStack;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Generics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPageFactory
implements IPageFactory {
    private final Map<Class<?>, Constructor<?>> constructorForClass = Generics.newConcurrentHashMap();

    @Override
    public final <C extends IRequestablePage> Page newPage(Class<C> pageClass) {
        try {
            Constructor<C> constructor = pageClass.getConstructor(null);
            return this.processPage(this.newPage(constructor, null), null);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = this.constructor(pageClass, PageParameters.class);
            if (constructor != null) {
                PageParameters pp = new PageParameters();
                return this.processPage(this.newPage(constructor, (Object)pp), pp);
            }
            throw new WicketRuntimeException("Unable to create page from " + pageClass + ". Class does not have a default contructor", e);
        }
    }

    @Override
    public final <C extends IRequestablePage> Page newPage(Class<C> pageClass, PageParameters parameters) {
        Constructor<?> constructor = this.constructor(pageClass, PageParameters.class);
        if (constructor != null) {
            return this.processPage(this.newPage(constructor, (Object)parameters), parameters);
        }
        return this.processPage((Page)this.newPage((Class)pageClass), parameters);
    }

    private final <C extends IRequestablePage> Constructor<?> constructor(Class<C> pageClass, Class<PageParameters> argumentType) {
        Constructor<Object> constructor = this.constructorForClass.get(pageClass);
        if (constructor == null) {
            try {
                constructor = pageClass.getConstructor(argumentType);
                this.constructorForClass.put(pageClass, constructor);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return constructor;
    }

    private final Page newPage(Constructor<?> constructor, Object argument) {
        try {
            if (argument != null) {
                return (Page)constructor.newInstance(argument);
            }
            return (Page)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (IllegalAccessException e) {
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RequestHandlerStack.ReplaceHandlerException || e.getTargetException() instanceof AuthorizationException || e.getTargetException() instanceof MarkupException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new WicketRuntimeException(this.createDescription(constructor, argument), e);
        }
    }

    private Page processPage(Page page, PageParameters pageParameters) {
        if (pageParameters != null && page.getPageParameters() != pageParameters) {
            page.getPageParameters().overwriteWith(pageParameters);
        }
        page.setWasCreatedBookmarkable(true);
        return page;
    }

    private String createDescription(Constructor<?> constructor, Object argument) {
        if (argument != null) {
            return "Can't instantiate page using constructor " + constructor + " and argument " + argument;
        }
        return "Can't instantiate page using constructor " + constructor;
    }
}

