/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.Response;

public class ByteArrayResponse
extends Response {
    private ByteArrayOutputStream bytes;
    private Response original;

    public ByteArrayResponse(Response original) {
        this.original = original;
        this.reset();
    }

    public ByteArrayResponse() {
        this(null);
    }

    public byte[] getBytes() {
        return this.bytes.toByteArray();
    }

    public void write(CharSequence string) {
        try {
            this.bytes.write(((Object)string).toString().getBytes());
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Cannot write into internal byte stream", e);
        }
    }

    public void reset() {
        this.bytes = new ByteArrayOutputStream();
    }

    public void write(byte[] array) {
        try {
            this.bytes.write(array);
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Cannot write into internal byte stream", e);
        }
    }

    public String encodeURL(CharSequence url) {
        if (this.original != null) {
            return this.original.encodeURL(url);
        }
        return url != null ? ((Object)url).toString() : null;
    }

    public Object getContainerResponse() {
        return this.original.getContainerResponse();
    }
}

