/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.filtering;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.DecoratingHeaderResponse;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.response.StringResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderResponseContainerFilteringHeaderResponse
extends DecoratingHeaderResponse {
    private static final Logger log = LoggerFactory.getLogger(Component.class);
    private static final MetaDataKey<HeaderResponseContainerFilteringHeaderResponse> RESPONSE_KEY = new MetaDataKey<HeaderResponseContainerFilteringHeaderResponse>(){
        private static final long serialVersionUID = 1L;
    };
    private final Map<String, StringResponse> responseFilterMap = new HashMap<String, StringResponse>();
    private IHeaderResponseFilter[] filters;
    private final String headerFilterName;

    public HeaderResponseContainerFilteringHeaderResponse(IHeaderResponse response, String headerFilterName, IHeaderResponseFilter[] filters) {
        super(response);
        this.headerFilterName = headerFilterName;
        this.setFilters(filters);
        RequestCycle.get().setMetaData(RESPONSE_KEY, this);
    }

    protected void setFilters(IHeaderResponseFilter[] filters) {
        this.filters = filters;
        if (filters == null) {
            return;
        }
        for (IHeaderResponseFilter filter : filters) {
            this.responseFilterMap.put(filter.getName(), new StringResponse());
        }
    }

    public static HeaderResponseContainerFilteringHeaderResponse get() {
        RequestCycle requestCycle = RequestCycle.get();
        if (requestCycle == null) {
            throw new IllegalStateException("you can only get the HeaderResponseContainerFilteringHeaderResponse when there is a RequestCycle present");
        }
        HeaderResponseContainerFilteringHeaderResponse response = requestCycle.getMetaData(RESPONSE_KEY);
        if (response == null) {
            throw new IllegalStateException("no HeaderResponseContainerFilteringHeaderResponse is present in the request cycle.  This may mean that you have not decorated the header response with a HeaderResponseContainerFilteringHeaderResponse.  Simply calling the HeaderResponseContainerFilteringHeaderResponse constructor sets itself on the request cycle");
        }
        return response;
    }

    public void renderJavaScriptReference(final ResourceReference reference) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavaScriptReference(reference);
            }
        });
    }

    public void renderJavaScriptReference(ResourceReference reference, String id) {
        this.renderJavaScriptReference(reference, null, id);
    }

    public void renderJavaScriptReference(final ResourceReference reference, final PageParameters pageParameters, final String id) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavaScriptReference(reference, pageParameters, id);
            }
        });
    }

    public void renderJavaScriptReference(final String url) {
        this.forJavaScript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavaScriptReference(url);
            }
        });
    }

    public void renderJavaScriptReference(final String url, final String id) {
        this.forJavaScript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavaScriptReference(url, id);
            }
        });
    }

    public void renderJavaScript(final CharSequence javascript, final String id) {
        this.forJavaScript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderJavaScript(javascript, id);
            }
        });
    }

    public void renderCSSReference(final ResourceReference reference) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(reference);
            }
        });
    }

    public void renderCSSReference(final String url) {
        this.forCss(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(url);
            }
        });
    }

    public void renderCSSReference(ResourceReference reference, String media) {
        this.renderCSSReference(reference, null, media);
    }

    public void renderCSSReference(final ResourceReference reference, final PageParameters pageParameters, final String media) {
        this.forReference(reference, new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(reference, pageParameters, media);
            }
        });
    }

    public void renderCSSReference(final String url, final String media) {
        this.forCss(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderCSSReference(url, media);
            }
        });
    }

    public void renderOnDomReadyJavaScript(final String javascript) {
        this.forJavaScript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderOnDomReadyJavaScript(javascript);
            }
        });
    }

    public void renderOnLoadJavaScript(final String javascript) {
        this.forJavaScript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderOnLoadJavaScript(javascript);
            }
        });
    }

    public void renderOnEventJavaScript(final String target, final String event, final String javascript) {
        this.forJavaScript(new Runnable(){

            public void run() {
                HeaderResponseContainerFilteringHeaderResponse.this.getRealResponse().renderOnEventJavaScript(target, event, javascript);
            }
        });
    }

    public void close() {
        CharSequence headerContent = this.getContent(this.headerFilterName);
        RequestCycle.get().getResponse().write(headerContent);
        super.close();
    }

    public final CharSequence getContent(String filterName) {
        if (filterName == null) {
            return "";
        }
        StringResponse resp = this.responseFilterMap.get(filterName);
        return resp == null ? "" : resp.getBuffer();
    }

    private void forReference(ResourceReference reference, Runnable runnable) {
        for (IHeaderResponseFilter filter : this.filters) {
            if (!filter.acceptReference(reference)) continue;
            this.run(runnable, filter);
            return;
        }
        log.warn("a ResourceReference was rendered to the filtering header response, but did not match any filters, so it was effectively lost.  Make sure that you have filters that accept every possible case or else configure a default filter that returns true to all acceptance tests");
    }

    private void forJavaScript(Runnable runnable) {
        for (IHeaderResponseFilter filter : this.filters) {
            if (!filter.acceptOtherJavaScript()) continue;
            this.run(runnable, filter);
            return;
        }
        log.warn("javascript was rendered to the filtering header response, but did not match any filters, so it was effectively lost.  Make sure that you have filters that accept every possible case or else configure a default filter that returns true to all acceptance tests");
    }

    private void forCss(Runnable runnable) {
        for (IHeaderResponseFilter filter : this.filters) {
            if (!filter.acceptOtherCss()) continue;
            this.run(runnable, filter);
            return;
        }
        log.warn("css was rendered to the filtering header response, but did not match any filters, so it was effectively lost.  Make sure that you have filters that accept every possible case or else configure a default filter that returns true to all acceptance tests");
    }

    protected final void runWithFilter(Runnable runnable, String filterName) {
        this.run(runnable, this.responseFilterMap.get(filterName));
    }

    private void run(Runnable runnable, IHeaderResponseFilter filter) {
        this.run(runnable, this.responseFilterMap.get(filter.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(Runnable runnable, Response response) {
        if (AjaxRequestTarget.get() != null) {
            runnable.run();
            return;
        }
        Response original = RequestCycle.get().setResponse(response);
        try {
            runnable.run();
        }
        finally {
            RequestCycle.get().setResponse(original);
        }
    }

    public static interface IHeaderResponseFilter {
        public String getName();

        public boolean acceptReference(ResourceReference var1);

        public boolean acceptOtherJavaScript();

        public boolean acceptOtherCss();
    }
}

