/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.aggregation;

import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.aggregation.AbstractResourceAggregatingHeaderResponse;
import org.apache.wicket.resource.aggregation.ResourceReferenceAndStringData;
import org.apache.wicket.resource.aggregation.ResourceReferenceCollection;
import org.apache.wicket.resource.dependencies.AbstractResourceDependentResourceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyRespectingResourceAggregatingHeaderResponse<R extends ResourceReferenceCollection, K>
extends AbstractResourceAggregatingHeaderResponse<R, K> {
    public AbstractDependencyRespectingResourceAggregatingHeaderResponse(IHeaderResponse real) {
        super(real);
    }

    @Override
    protected void renderCollection(Set<ResourceReferenceAndStringData> alreadyRendered, K key, R coll) {
        for (ResourceReferenceAndStringData data : coll) {
            ResourceReference ref = data.getReference();
            if (ref instanceof AbstractResourceDependentResourceReference) {
                AbstractResourceDependentResourceReference parent = (AbstractResourceDependentResourceReference)ref;
                Object childColl = this.newResourceReferenceCollection(key);
                for (AbstractResourceDependentResourceReference child : parent.getDependentResourceReferences()) {
                    ((HashSet)childColl).add((ResourceReferenceAndStringData)AbstractDependencyRespectingResourceAggregatingHeaderResponse.toData(child));
                }
                this.renderCollection(alreadyRendered, key, childColl);
            }
            this.renderIfNotAlreadyRendered(alreadyRendered, data);
        }
    }

    private static ResourceReferenceAndStringData toData(AbstractResourceDependentResourceReference child) {
        boolean css = AbstractResourceDependentResourceReference.ResourceType.CSS.equals((Object)child.getResourceType());
        String string = css ? child.getMedia() : child.getUniqueId();
        return new ResourceReferenceAndStringData(child, string, css);
    }
}

