/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching;

import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.AbstractResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;

public class QueryStringWithTimestampResourceCachingStrategy
extends AbstractResourceCachingStrategy {
    private static final String DEFAULT_TIMESTAMP_PARAMETER = "ts";
    private final String timestampParameter;

    public QueryStringWithTimestampResourceCachingStrategy() {
        this(DEFAULT_TIMESTAMP_PARAMETER);
    }

    public QueryStringWithTimestampResourceCachingStrategy(String timestampParameter) {
        Args.notEmpty((CharSequence)timestampParameter, (String)"timestampParameter");
        this.timestampParameter = timestampParameter;
    }

    public final String getTimestampParameter() {
        return this.timestampParameter;
    }

    public void decorateUrl(ResourceUrl url, ResourceReference reference) {
        Time lastModified = this.getLastModified(reference);
        if (lastModified != null) {
            url.getParameters().set(this.timestampParameter, (Object)lastModified.getMilliseconds());
        }
    }

    public void undecorateUrl(ResourceUrl url) {
        url.getParameters().remove(this.timestampParameter);
    }

    public void decorateResponse(AbstractResource.ResourceResponse response) {
        response.setCacheDurationToMaximum();
        response.setCacheScope(WebResponse.CacheScope.PUBLIC);
    }
}

