/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching;

import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.AbstractResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.ResourceUrl;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Time;

public class FilenameWithTimestampResourceCachingStrategy
extends AbstractResourceCachingStrategy {
    protected static final String DEFAULT_TIMESTAMP_SUFFIX = "-ts";
    private final String timestampPrefix;

    public FilenameWithTimestampResourceCachingStrategy() {
        this(DEFAULT_TIMESTAMP_SUFFIX);
    }

    public FilenameWithTimestampResourceCachingStrategy(String timestampSuffix) {
        Args.notEmpty((CharSequence)timestampSuffix, (String)"timestampPrefix");
        this.timestampPrefix = timestampSuffix;
    }

    public final String getTimestampPrefix() {
        return this.timestampPrefix;
    }

    public void decorateUrl(ResourceUrl url, ResourceReference reference) {
        Time lastModified = this.getLastModified(reference);
        String filename = url.getFileName();
        if (lastModified == null) {
            return;
        }
        int extensionAt = filename.lastIndexOf(46);
        StringBuilder timestampedFilename = new StringBuilder();
        timestampedFilename.append(extensionAt == -1 ? filename : filename.substring(0, extensionAt));
        timestampedFilename.append(this.timestampPrefix);
        timestampedFilename.append(lastModified.getMilliseconds());
        if (extensionAt != -1) {
            timestampedFilename.append(filename.substring(extensionAt));
        }
        url.setFileName(timestampedFilename.toString());
    }

    public void undecorateUrl(ResourceUrl url) {
        String filename = url.getFileName();
        int pos = filename.lastIndexOf(46);
        String fullname = pos == -1 ? filename : filename.substring(0, pos);
        String extension = pos == -1 ? null : filename.substring(pos);
        pos = fullname.lastIndexOf(this.timestampPrefix);
        if (pos != -1) {
            String timestamp = fullname.substring(pos + this.timestampPrefix.length());
            String basename = fullname.substring(0, pos);
            try {
                Long.parseLong(timestamp);
                url.setFileName(extension == null ? basename : basename + extension);
                return;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    public void decorateResponse(AbstractResource.ResourceResponse response) {
        response.setCacheDurationToMaximum();
        response.setCacheScope(WebResponse.CacheScope.PUBLIC);
    }
}

