/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource.caching;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.time.Time;

public abstract class AbstractResourceCachingStrategy
implements IResourceCachingStrategy {
    protected static final MetaDataKey<Map<ResourceReference, Time>> TIMESTAMP_KEY = new MetaDataKey<Map<ResourceReference, Time>>(){
        private static final long serialVersionUID = 1L;
    };
    private boolean lastModifiedCacheEnabled = true;

    public boolean isLastModifiedCacheEnabled() {
        return this.lastModifiedCacheEnabled;
    }

    public void setLastModifiedCacheEnabled(boolean enabled) {
        this.lastModifiedCacheEnabled = enabled;
    }

    protected Time getLastModified(ResourceReference resourceReference) {
        Map<ResourceReference, Time> cache;
        Application application = ThreadContext.getApplication();
        if (application == null) {
            return resourceReference.getLastModified();
        }
        if (application.usesDevelopmentConfig()) {
            RequestCycle requestCycle = ThreadContext.getRequestCycle();
            cache = requestCycle.getMetaData(TIMESTAMP_KEY);
            if (cache == null) {
                cache = Generics.newHashMap();
                requestCycle.setMetaData(TIMESTAMP_KEY, cache);
            }
        } else {
            cache = application.getMetaData(TIMESTAMP_KEY);
            if (cache == null) {
                cache = Collections.synchronizedMap(new HashMap());
                application.setMetaData(TIMESTAMP_KEY, cache);
            }
        }
        if (cache.containsKey(resourceReference)) {
            return (Time)cache.get(resourceReference);
        }
        Time lastModified = resourceReference.getLastModified();
        cache.put(resourceReference, lastModified);
        return lastModified;
    }
}

