/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.Serializable;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Objects;
import org.apache.wicket.util.lang.WicketObjects;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceReference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Key data;

    public ResourceReference(Key key) {
        Args.notNull((Object)key, (String)"key");
        this.data = key;
    }

    public ResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        Args.notNull(scope, (String)"scope");
        Args.notNull((Object)name, (String)"name");
        this.data = new Key(scope.getName(), name, locale, style, variation);
    }

    public ResourceReference(Class<?> scope, String name) {
        this(scope, name, null, null, null);
    }

    public ResourceReference(String name) {
        this(Application.class, name, null, null, null);
    }

    Key getKey() {
        return this.data;
    }

    public String getName() {
        return this.data.getName();
    }

    public final String getExtension() {
        int extPos;
        String name = this.getName();
        int queryAt = name.indexOf(63);
        if (queryAt != -1) {
            name = name.substring(0, queryAt);
        }
        if ((extPos = name.lastIndexOf(46)) == -1) {
            return null;
        }
        return name.substring(extPos + 1).toLowerCase();
    }

    public Class<?> getScope() {
        return WicketObjects.resolveClass(this.data.getScope());
    }

    public Locale getLocale() {
        return this.data.getLocale();
    }

    public String getStyle() {
        return this.data.getStyle();
    }

    public String getVariation() {
        return this.data.getVariation();
    }

    public boolean canBeRegistered() {
        return true;
    }

    public Time getLastModified() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceReference)) {
            return false;
        }
        ResourceReference that = (ResourceReference)obj;
        return Objects.equal((Object)this.data, (Object)that.data);
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    public abstract IResource getResource();

    public UrlAttributes getUrlAttributes() {
        return new UrlAttributes(this.getLocale(), this.getStyle(), this.getVariation());
    }

    public String toString() {
        return this.data.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Key
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String scope;
        final String name;
        final Locale locale;
        final String style;
        final String variation;

        public Key(ResourceReference reference) {
            this(reference.getScope().getName(), reference.getName(), reference.getLocale(), reference.getStyle(), reference.getVariation());
        }

        public Key(String scope, String name, Locale locale, String style, String variation) {
            Args.notNull((Object)scope, (String)"scope");
            Args.notNull((Object)name, (String)"name");
            this.scope = scope.intern();
            this.name = name.intern();
            this.locale = locale;
            this.style = style != null ? style.intern() : null;
            this.variation = variation != null ? variation.intern() : null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key that = (Key)obj;
            return Objects.equal((Object)this.scope, (Object)that.scope) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.locale, (Object)that.locale) && Objects.equal((Object)this.style, (Object)that.style) && Objects.equal((Object)this.variation, (Object)that.variation);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.scope, this.name, this.locale, this.style, this.variation});
        }

        public final String getScope() {
            return this.scope;
        }

        public final Class<?> getScopeClass() {
            return WicketObjects.resolveClass(this.scope);
        }

        public final String getName() {
            return this.name;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        public final String getStyle() {
            return this.style;
        }

        public final String getVariation() {
            return this.variation;
        }

        public String toString() {
            return "scope: " + this.scope + "; name: " + this.name + "; locale: " + this.locale + "; style: " + this.style + "; variation: " + this.variation;
        }
    }

    public static class UrlAttributes {
        private final Locale locale;
        private final String style;
        private final String variation;

        public UrlAttributes(Locale locale, String style, String variation) {
            this.locale = locale;
            this.style = style;
            this.variation = variation;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getStyle() {
            return this.style;
        }

        public String getVariation() {
            return this.variation;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof UrlAttributes)) {
                return false;
            }
            UrlAttributes that = (UrlAttributes)obj;
            return Objects.equal((Object)this.getLocale(), (Object)that.getLocale()) && Objects.equal((Object)this.getStyle(), (Object)that.getStyle()) && Objects.equal((Object)this.getVariation(), (Object)that.getVariation());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getLocale(), this.getStyle(), this.getVariation()});
        }

        public String toString() {
            return "locale: " + this.locale + "; style: " + this.style + "; variation: " + this.variation;
        }
    }
}

