/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.request.resource.CssPackageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.JavaScriptPackageResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.util.time.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private static final String CSS_EXTENSION = "css";
    private static final String JAVASCRIPT_EXTENSION = "js";
    private transient ConcurrentMap<ResourceReference.UrlAttributes, ResourceReference.UrlAttributes> urlAttributesCacheMap;

    public PackageResourceReference(ResourceReference.Key key) {
        super(key);
    }

    public PackageResourceReference(Class<?> scope, String name, Locale locale, String style, String variation) {
        super(scope, name, locale, style, variation);
    }

    public PackageResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    public PackageResourceReference(String name) {
        super(name);
    }

    @Override
    public IResource getResource() {
        String extension = this.getExtension();
        if (CSS_EXTENSION.equals(extension)) {
            return new CssPackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation());
        }
        if (JAVASCRIPT_EXTENSION.equals(extension)) {
            return new JavaScriptPackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation());
        }
        return new PackageResource(this.getScope(), this.getName(), this.getLocale(), this.getStyle(), this.getVariation());
    }

    private StreamInfo lookupStream(Locale locale, String style, String variation) {
        IResourceStreamLocator locator = Application.get().getResourceSettings().getResourceStreamLocator();
        String absolutePath = Packages.absolutePath(this.getScope(), (String)this.getName());
        IResourceStream stream = locator.locate(this.getScope(), absolutePath, style, variation, locale, null, false);
        if (stream == null) {
            return null;
        }
        return new StreamInfo(stream);
    }

    private ResourceReference.UrlAttributes getUrlAttributes(Locale locale, String style, String variation) {
        StreamInfo info = this.lookupStream(locale, style, variation);
        if (info != null) {
            return new ResourceReference.UrlAttributes(info.locale, info.style, info.variation);
        }
        return new ResourceReference.UrlAttributes(null, null, null);
    }

    private Locale getCurrentLocale() {
        return this.getLocale() != null ? this.getLocale() : Session.get().getLocale();
    }

    private String getCurrentStyle() {
        return this.getStyle() != null ? this.getStyle() : Session.get().getStyle();
    }

    @Override
    public Time getLastModified() {
        StreamInfo info = this.lookupStream(this.getCurrentLocale(), this.getCurrentStyle(), this.getVariation());
        if (info == null) {
            return null;
        }
        return info.stream.lastModifiedTime();
    }

    @Override
    public ResourceReference.UrlAttributes getUrlAttributes() {
        ResourceReference.UrlAttributes value;
        Locale locale = this.getCurrentLocale();
        String style = this.getCurrentStyle();
        String variation = this.getVariation();
        ResourceReference.UrlAttributes key = new ResourceReference.UrlAttributes(locale, style, variation);
        if (this.urlAttributesCacheMap == null) {
            this.urlAttributesCacheMap = Generics.newConcurrentHashMap();
        }
        if ((value = (ResourceReference.UrlAttributes)this.urlAttributesCacheMap.get(key)) == null) {
            value = this.getUrlAttributes(locale, style, variation);
            this.urlAttributesCacheMap.put(key, value);
        }
        return value;
    }

    private static class StreamInfo {
        public final IResourceStream stream;
        public final Locale locale;
        public final String style;
        public final String variation;

        public StreamInfo(IResourceStream stream) {
            this.stream = stream;
            this.locale = stream.getLocale();
            this.style = stream.getStyle();
            this.variation = stream.getVariation();
        }
    }
}

