/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.wicket.Application;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.lang.WicketObjects;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResource
extends AbstractResource {
    private static final Logger log = LoggerFactory.getLogger(PackageResource.class);
    private static final long serialVersionUID = 1L;
    private final String absolutePath;
    private final Locale locale;
    private final String path;
    private final String scopeName;
    private final String style;
    private final String variation;

    protected PackageResource(Class<?> scope, String name, Locale locale, String style, String variation) {
        this.absolutePath = Packages.absolutePath(scope, (String)name);
        String parentEscape = Application.get().getResourceSettings().getParentFolderPlaceholder();
        this.path = !Strings.isEmpty((CharSequence)parentEscape) ? ((Object)Strings.replaceAll((CharSequence)name, (CharSequence)"../", (CharSequence)(parentEscape + "/"))).toString() : name;
        if (!this.accept(scope, this.path)) {
            throw new PackageResourceBlockedException("Access denied to (static) package resource " + this.absolutePath + ". See IPackageResourceGuard");
        }
        this.scopeName = scope.getName();
        this.locale = locale;
        this.style = style;
        this.variation = variation;
    }

    public final Class<?> getScope() {
        return WicketObjects.resolveClass(this.scopeName);
    }

    public final String getStyle() {
        return this.style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        if (resourceResponse.dataNeedsToBeWritten(attributes)) {
            IResourceStream resourceStream = this.getResourceStream();
            if (resourceStream == null) {
                return this.sendResourceError(resourceResponse, 404, "Unable to find resource");
            }
            resourceResponse.setContentType(resourceStream.getContentType());
            Time lastModified = resourceStream.lastModifiedTime();
            if (lastModified != null) {
                resourceResponse.setLastModified(lastModified);
            }
            try {
                byte[] bytes;
                try {
                    bytes = IOUtils.toByteArray((InputStream)resourceStream.getInputStream());
                }
                finally {
                    resourceStream.close();
                }
                final byte[] processed = this.processResponse(attributes, bytes);
                resourceResponse.setContentLength(processed.length);
                resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                    public void writeData(IResource.Attributes attributes) {
                        attributes.getResponse().write(processed);
                    }
                });
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
                return this.sendResourceError(resourceResponse, 500, "Unable to read resource stream");
            }
            catch (ResourceStreamNotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
                return this.sendResourceError(resourceResponse, 500, "Unable to open resource stream");
            }
        }
        Application.get().getResourceSettings().getCachingStrategy().decorateResponse(resourceResponse);
        return resourceResponse;
    }

    protected byte[] processResponse(IResource.Attributes attributes, byte[] original) {
        return original;
    }

    private AbstractResource.ResourceResponse sendResourceError(AbstractResource.ResourceResponse resourceResponse, int errorCode, String errorMessage) {
        String msg = String.format("resource [path = %s, style = %s, variation = %s, locale = %s]: %s (status=%d)", this.absolutePath, this.style, this.variation, this.locale, errorMessage, errorCode);
        log.warn(msg);
        resourceResponse.setError(errorCode, errorMessage);
        return resourceResponse;
    }

    protected IResourceStream getResourceStream() {
        return ThreadContext.getApplication().getResourceSettings().getResourceStreamLocator().locate(this.getScope(), this.absolutePath, this.style, this.variation, this.locale, null, false);
    }

    private boolean accept(Class<?> scope, String path) {
        IPackageResourceGuard guard = ThreadContext.getApplication().getResourceSettings().getPackageResourceGuard();
        return guard.accept(scope, path);
    }

    public static boolean exists(Class<?> scope, String path, Locale locale, String style, String variation) {
        String absolutePath = Packages.absolutePath(scope, (String)path);
        return ThreadContext.getApplication().getResourceSettings().getResourceStreamLocator().locate(scope, absolutePath, style, variation, locale, null, false) != null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[').append(this.getClass().getSimpleName()).append(' ').append("name = ").append(this.path).append(", scope = ").append(this.scopeName).append(", locale = ").append(this.locale).append(", style = ").append(this.style).append(", variation = ").append(this.variation).append(']');
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.absolutePath == null ? 0 : this.absolutePath.hashCode());
        result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.scopeName == null ? 0 : this.scopeName.hashCode());
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        result = 31 * result + (this.variation == null ? 0 : this.variation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageResource other = (PackageResource)obj;
        if (this.absolutePath == null ? other.absolutePath != null : !this.absolutePath.equals(other.absolutePath)) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.scopeName == null ? other.scopeName != null : !this.scopeName.equals(other.scopeName)) {
            return false;
        }
        if (this.style == null ? other.style != null : !this.style.equals(other.style)) {
            return false;
        }
        return !(this.variation == null ? other.variation != null : !this.variation.equals(other.variation));
    }

    public static final class PackageResourceBlockedException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        public PackageResourceBlockedException(String message) {
            super(message);
        }
    }
}

