/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.AbstractMapper;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class ResourceMapper
extends AbstractMapper
implements IRequestMapper {
    private final IPageParametersEncoder parametersEncoder;
    private final String[] mountSegments;
    private final ResourceReference resourceReference;

    public ResourceMapper(String path, ResourceReference resourceReference) {
        this(path, resourceReference, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public ResourceMapper(String path, ResourceReference resourceReference, IPageParametersEncoder encoder) {
        Args.notEmpty((CharSequence)path, (String)"path");
        Args.notNull((Object)resourceReference, (String)"resourceReference");
        Args.notNull((Object)encoder, (String)"encoder");
        this.resourceReference = resourceReference;
        this.mountSegments = this.getMountSegments(path);
        this.parametersEncoder = encoder;
    }

    public IRequestHandler mapRequest(Request request) {
        Url url = request.getUrl();
        if (!this.urlStartsWith(url, this.mountSegments)) {
            return null;
        }
        PageParameters parameters = this.extractPageParameters(request, this.mountSegments.length, this.parametersEncoder);
        for (int index = 0; index < this.mountSegments.length; ++index) {
            String placeholder = ResourceMapper.getPlaceholder((String)this.mountSegments[index]);
            if (placeholder == null) continue;
            if (parameters == null) {
                parameters = new PageParameters();
            }
            parameters.add(placeholder, url.getSegments().get(index));
        }
        return new ResourceReferenceRequestHandler(this.resourceReference, parameters);
    }

    public int getCompatibilityScore(Request request) {
        return 0;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        if (!(requestHandler instanceof ResourceReferenceRequestHandler)) {
            return null;
        }
        ResourceReferenceRequestHandler handler = (ResourceReferenceRequestHandler)requestHandler;
        if (!this.resourceReference.equals(handler.getResourceReference()) && !this.resourceReference.getResource().equals(handler.getResource())) {
            return null;
        }
        Url url = new Url();
        for (String segment : this.mountSegments) {
            url.getSegments().add(segment);
        }
        PageParameters parameters = new PageParameters(handler.getPageParameters());
        for (int index = 0; index < this.mountSegments.length; ++index) {
            String placeholder = ResourceMapper.getPlaceholder((String)this.mountSegments[index]);
            if (placeholder == null) continue;
            url.getSegments().set(index, parameters.get(placeholder).toString(""));
            parameters.remove(placeholder);
        }
        return this.encodePageParameters(url, parameters, this.parametersEncoder);
    }
}

