/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.PackageName;

public class PackageMapper
extends AbstractBookmarkableMapper {
    private final PackageName packageName;
    private final IPageParametersEncoder pageParametersEncoder;

    public PackageMapper(PackageName packageName) {
        this(packageName, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public PackageMapper(PackageName packageName, IPageParametersEncoder pageParametersEncoder) {
        Args.notNull((Object)packageName, (String)"packageName");
        Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.packageName = packageName;
        this.pageParametersEncoder = pageParametersEncoder;
    }

    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Class<? extends IRequestablePage> pageClass = info.getPageClass();
        if (PackageName.forClass(pageClass).equals((Object)this.packageName)) {
            Url url = new Url();
            url.getSegments().add(pageClass.getSimpleName());
            this.encodePageComponentInfo(url, info.getPageComponentInfo());
            return this.encodePageParameters(url, info.getPageParameters(), this.pageParametersEncoder);
        }
        return null;
    }

    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        Url url = request.getUrl();
        if (url.getSegments().size() >= 1) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            String className = (String)url.getSegments().get(0);
            String fullyQualifiedClassName = this.packageName.getName() + '.' + className;
            Class<? extends IRequestablePage> pageClass = this.getPageClass(fullyQualifiedClassName);
            if (pageClass != null && IRequestablePage.class.isAssignableFrom(pageClass)) {
                PageParameters pageParameters = this.extractPageParameters(request, 1, this.pageParametersEncoder);
                return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
            }
        }
        return null;
    }

    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return true;
    }

    public int getCompatibilityScore(Request request) {
        return 0;
    }
}

