/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.mapper.AbstractBookmarkableMapper;
import org.apache.wicket.request.mapper.info.PageComponentInfo;
import org.apache.wicket.request.mapper.parameter.IPageParametersEncoder;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.mapper.parameter.PageParametersEncoder;
import org.apache.wicket.util.ClassProvider;
import org.apache.wicket.util.lang.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MountedMapper
extends AbstractBookmarkableMapper {
    private final IPageParametersEncoder pageParametersEncoder;
    private final List<MountPathSegment> pathSegments;
    private final String[] mountSegments;
    private final ClassProvider<? extends IRequestablePage> pageClassProvider;

    public MountedMapper(String mountPath, Class<? extends IRequestablePage> pageClass) {
        this(mountPath, pageClass, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public MountedMapper(String mountPath, ClassProvider<? extends IRequestablePage> pageClassProvider) {
        this(mountPath, pageClassProvider, (IPageParametersEncoder)new PageParametersEncoder());
    }

    public MountedMapper(String mountPath, Class<? extends IRequestablePage> pageClass, IPageParametersEncoder pageParametersEncoder) {
        this(mountPath, (ClassProvider<? extends IRequestablePage>)ClassProvider.of(pageClass), pageParametersEncoder);
    }

    public MountedMapper(String mountPath, ClassProvider<? extends IRequestablePage> pageClassProvider, IPageParametersEncoder pageParametersEncoder) {
        Args.notEmpty((CharSequence)mountPath, (String)"mountPath");
        Args.notNull(pageClassProvider, (String)"pageClassProvider");
        Args.notNull((Object)pageParametersEncoder, (String)"pageParametersEncoder");
        this.pageParametersEncoder = pageParametersEncoder;
        this.pageClassProvider = pageClassProvider;
        this.mountSegments = this.getMountSegments(mountPath);
        this.pathSegments = this.getPathSegments(this.mountSegments);
    }

    private List<MountPathSegment> getPathSegments(String[] segments) {
        ArrayList<MountPathSegment> ret = new ArrayList<MountPathSegment>();
        int segmentIndex = 0;
        MountPathSegment curPathSegment = new MountPathSegment(segmentIndex);
        ret.add(curPathSegment);
        for (String curSegment : segments) {
            if (this.isFixedSegment(curSegment)) {
                curPathSegment.setFixedPart(curSegment);
                curPathSegment = new MountPathSegment(segmentIndex + 1);
                ret.add(curPathSegment);
            } else if (MountedMapper.getPlaceholder((String)curSegment) != null) {
                curPathSegment.addRequiredParameter();
            } else {
                curPathSegment.addOptionalParameter();
            }
            ++segmentIndex;
        }
        return ret;
    }

    private boolean isFixedSegment(String segment) {
        return MountedMapper.getOptionalPlaceholder((String)segment) == null && MountedMapper.getPlaceholder((String)segment) == null;
    }

    @Override
    protected AbstractBookmarkableMapper.UrlInfo parseRequest(Request request) {
        Url url = request.getUrl();
        if (this.redirectFromHomePage() && this.checkHomePage(url)) {
            return new AbstractBookmarkableMapper.UrlInfo(null, this.getContext().getHomePageClass(), this.newPageParameters());
        }
        if (this.urlStartsWith(url, this.mountSegments)) {
            PageComponentInfo info = this.getPageComponentInfo(url);
            Class<? extends IRequestablePage> pageClass = this.getPageClass();
            PageParameters pageParameters = this.extractPageParameters(request, url);
            return new AbstractBookmarkableMapper.UrlInfo(info, pageClass, pageParameters);
        }
        return null;
    }

    private PageParameters extractPageParameters(Request request, Url url) {
        int[] matchedParameters = this.getMatchedSegmentSizes(url);
        int total = 0;
        for (int curMatchSize : matchedParameters) {
            total += curMatchSize;
        }
        PageParameters pageParameters = this.extractPageParameters(request, total, this.pageParametersEncoder);
        int skippedParameters = 0;
        for (int pathSegmentIndex = 0; pathSegmentIndex < this.pathSegments.size(); ++pathSegmentIndex) {
            MountPathSegment curPathSegment = this.pathSegments.get(pathSegmentIndex);
            int matchSize = matchedParameters[pathSegmentIndex] - curPathSegment.getFixedPartSize();
            int optionalParameterMatch = matchSize - curPathSegment.getMinParameters();
            for (int matchSegment = 0; matchSegment < matchSize; ++matchSegment) {
                if (pageParameters == null) {
                    pageParameters = new PageParameters();
                }
                int curSegmentIndex = matchSegment + curPathSegment.getSegmentIndex();
                String curSegment = this.mountSegments[curSegmentIndex];
                String placeholder = MountedMapper.getPlaceholder((String)curSegment);
                String optionalPlaceholder = MountedMapper.getOptionalPlaceholder((String)curSegment);
                if (placeholder != null) {
                    pageParameters.add(placeholder, url.getSegments().get(curSegmentIndex - skippedParameters));
                    continue;
                }
                if (optionalPlaceholder == null || optionalParameterMatch <= 0) continue;
                pageParameters.add(optionalPlaceholder, url.getSegments().get(curSegmentIndex - skippedParameters));
                --optionalParameterMatch;
            }
            skippedParameters += curPathSegment.getMaxParameters() - matchSize;
        }
        return pageParameters;
    }

    protected boolean urlStartsWith(Url url, String ... segments) {
        if (url == null) {
            return false;
        }
        return this.getMatchedSegmentSizes(url) != null;
    }

    private int[] getMatchedSegmentSizes(Url url) {
        int[] ret = new int[this.pathSegments.size()];
        int segmentIndex = 0;
        int pathSegmentIndex = 0;
        for (MountPathSegment curPathSegment : this.pathSegments.subList(0, this.pathSegments.size() - 1)) {
            boolean foundFixedPart = false;
            int max = Math.min(curPathSegment.getOptionalParameters() + 1, url.getSegments().size() - (segmentIndex += curPathSegment.getMinParameters()));
            for (int count = max - 1; count >= 0; --count) {
                if (!((String)url.getSegments().get(segmentIndex + count)).equals(curPathSegment.getFixedPart())) continue;
                foundFixedPart = true;
                segmentIndex += count + 1;
                ret[pathSegmentIndex] = count + curPathSegment.getMinParameters() + 1;
                break;
            }
            if (!foundFixedPart) {
                return null;
            }
            ++pathSegmentIndex;
        }
        MountPathSegment lastSegment = this.pathSegments.get(this.pathSegments.size() - 1);
        if ((segmentIndex += lastSegment.getMinParameters()) > url.getSegments().size()) {
            return null;
        }
        ret[pathSegmentIndex] = Math.min(lastSegment.getMaxParameters(), url.getSegments().size() - segmentIndex + lastSegment.getMinParameters());
        return ret;
    }

    protected PageParameters newPageParameters() {
        return new PageParameters();
    }

    @Override
    protected Url buildUrl(AbstractBookmarkableMapper.UrlInfo info) {
        Url url = new Url();
        for (String s : this.mountSegments) {
            url.getSegments().add(s);
        }
        this.encodePageComponentInfo(url, info.getPageComponentInfo());
        PageParameters copy = new PageParameters(info.getPageParameters());
        int dropped = 0;
        for (int i = 0; i < this.mountSegments.length; ++i) {
            String placeholder = MountedMapper.getPlaceholder((String)this.mountSegments[i]);
            String optionalPlaceholder = MountedMapper.getOptionalPlaceholder((String)this.mountSegments[i]);
            if (placeholder != null) {
                url.getSegments().set(i - dropped, copy.get(placeholder).toString(""));
                copy.remove(placeholder);
                continue;
            }
            if (optionalPlaceholder == null) continue;
            if (copy.getNamedKeys().contains(optionalPlaceholder)) {
                url.getSegments().set(i - dropped, copy.get(optionalPlaceholder).toString(""));
                copy.remove(optionalPlaceholder);
                continue;
            }
            url.getSegments().remove(i - dropped);
            ++dropped;
        }
        return this.encodePageParameters(url, copy, this.pageParametersEncoder);
    }

    private boolean checkHomePage(Url url) {
        return url.getSegments().isEmpty() && url.getQueryParameters().isEmpty() && this.getPageClass().equals(this.getContext().getHomePageClass()) && this.redirectFromHomePage();
    }

    protected boolean redirectFromHomePage() {
        return true;
    }

    @Override
    protected boolean pageMustHaveBeenCreatedBookmarkable() {
        return false;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        if (this.urlStartsWith(request.getUrl(), this.mountSegments)) {
            return this.mountSegments.length;
        }
        return 0;
    }

    @Override
    protected boolean checkPageClass(Class<? extends IRequestablePage> pageClass) {
        return pageClass.equals(this.getPageClass());
    }

    private Class<? extends IRequestablePage> getPageClass() {
        return this.pageClassProvider.get();
    }

    private static class MountPathSegment {
        private int segmentIndex;
        private String fixedPart;
        private int minParameters;
        private int optionalParameters;

        public MountPathSegment(int segmentIndex) {
            this.segmentIndex = segmentIndex;
        }

        public void setFixedPart(String fixedPart) {
            this.fixedPart = fixedPart;
        }

        public void addRequiredParameter() {
            ++this.minParameters;
        }

        public void addOptionalParameter() {
            ++this.optionalParameters;
        }

        public int getSegmentIndex() {
            return this.segmentIndex;
        }

        public String getFixedPart() {
            return this.fixedPart;
        }

        public int getMinParameters() {
            return this.minParameters;
        }

        public int getOptionalParameters() {
            return this.optionalParameters;
        }

        public int getMaxParameters() {
            return this.getOptionalParameters() + this.getMinParameters();
        }

        public int getFixedPartSize() {
            return this.getFixedPart() == null ? 0 : 1;
        }

        public String toString() {
            return "(" + this.getSegmentIndex() + ") " + this.getMinParameters() + "-" + this.getMaxParameters() + " " + (this.getFixedPart() == null ? "(end)" : this.getFixedPart());
        }
    }
}

