/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.IProvider;
import org.apache.wicket.util.crypt.ICrypt;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CryptoMapper
implements IRequestMapper {
    private static final Logger log = LoggerFactory.getLogger(CryptoMapper.class);
    private final IRequestMapper wrappedMapper;
    private final IProvider<ICrypt> cryptProvider;

    public CryptoMapper(IRequestMapper wrappedMapper, Application application) {
        this(wrappedMapper, new ApplicationCryptProvider(application));
    }

    public CryptoMapper(IRequestMapper wrappedMapper, IProvider<ICrypt> cryptProvider) {
        this.wrappedMapper = wrappedMapper;
        this.cryptProvider = cryptProvider;
    }

    public int getCompatibilityScore(Request request) {
        return 0;
    }

    public Url mapHandler(IRequestHandler requestHandler) {
        Url url = this.wrappedMapper.mapHandler(requestHandler);
        if (url == null) {
            return null;
        }
        return this.encryptUrl(url);
    }

    public IRequestHandler mapRequest(Request request) {
        Url url = this.decryptUrl(request, request.getUrl());
        if (url == null) {
            return null;
        }
        return this.wrappedMapper.mapRequest(request.cloneWithUrl(url));
    }

    private ICrypt getCrypt() {
        return (ICrypt)this.cryptProvider.get();
    }

    private Url encryptUrl(Url url) {
        if (url.getSegments().isEmpty() && url.getQueryParameters().isEmpty()) {
            return url;
        }
        String encryptedUrlString = this.getCrypt().encryptUrlSafe(url.toString());
        Url encryptedUrl = new Url(url.getCharset());
        encryptedUrl.getSegments().add(encryptedUrlString);
        int numberOfSegments = url.getSegments().size();
        if (numberOfSegments == 0 && !url.getQueryParameters().isEmpty()) {
            numberOfSegments = 1;
        }
        char[] encryptedChars = encryptedUrlString.toCharArray();
        int hash = 0;
        for (int segNo = 0; segNo < numberOfSegments; ++segNo) {
            char a = encryptedChars[Math.abs(hash % encryptedChars.length)];
            char b = encryptedChars[Math.abs(++hash % encryptedChars.length)];
            char c = encryptedChars[Math.abs(++hash % encryptedChars.length)];
            String segment = "" + a + b + c;
            hash = this.hashString(segment);
            segment = segment + String.format("%02x", Math.abs(hash % 256));
            encryptedUrl.getSegments().add(segment);
            hash = this.hashString(segment);
        }
        return encryptedUrl;
    }

    private Url decryptUrl(Request request, Url encryptedUrl) {
        if (encryptedUrl.getSegments().isEmpty() && encryptedUrl.getQueryParameters().isEmpty()) {
            return encryptedUrl;
        }
        List segments = encryptedUrl.getSegments();
        if (segments.size() < 2) {
            return null;
        }
        Url url = new Url(request.getCharset());
        try {
            int segNo;
            String encryptedUrlString = (String)segments.get(0);
            if (Strings.isEmpty((CharSequence)encryptedUrlString)) {
                return null;
            }
            String decryptedUrl = this.getCrypt().decryptUrlSafe(encryptedUrlString);
            Url originalUrl = Url.parse((String)decryptedUrl, (Charset)request.getCharset());
            int originalNumberOfSegments = originalUrl.getSegments().size();
            int numberOfSegments = encryptedUrl.getSegments().size();
            char[] encryptedChars = encryptedUrlString.toCharArray();
            int hash = 0;
            for (segNo = 1; segNo < numberOfSegments && segNo < originalNumberOfSegments + 1; ++segNo) {
                char a = encryptedChars[Math.abs(hash % encryptedChars.length)];
                char b = encryptedChars[Math.abs(++hash % encryptedChars.length)];
                char c = encryptedChars[Math.abs(++hash % encryptedChars.length)];
                String segment = "" + a + b + c;
                hash = this.hashString(segment);
                segment = segment + String.format("%02x", Math.abs(hash % 256));
                hash = this.hashString(segment);
                if (!segment.equals(segments.get(segNo))) break;
                url.getSegments().add(originalUrl.getSegments().get(segNo - 1));
            }
            if (segNo < numberOfSegments) {
                url.getQueryParameters().addAll(originalUrl.getQueryParameters());
                while (segNo < numberOfSegments) {
                    url.getSegments().add(encryptedUrl.getSegments().get(segNo));
                    ++segNo;
                }
            } else {
                url.getQueryParameters().addAll(originalUrl.getQueryParameters());
            }
        }
        catch (Exception e) {
            log.error("Error decrypting URL", (Throwable)e);
            url = null;
        }
        return url;
    }

    private int hashString(String str) {
        int hash = 97;
        char[] arr$ = str.toCharArray();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            char c;
            char i = c = arr$[i$];
            hash = 47 * hash + i;
        }
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ApplicationCryptProvider
    implements IProvider<ICrypt> {
        private final Application application;

        public ApplicationCryptProvider(Application application) {
            this.application = application;
        }

        public ICrypt get() {
            return this.application.getSecuritySettings().getCryptFactory().newCrypt();
        }
    }
}

