/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler;

import org.apache.wicket.Application;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.IPageClassRequestHandler;
import org.apache.wicket.request.handler.IPageProvider;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.handler.render.PageRenderer;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderPageRequestHandler
implements IPageRequestHandler,
IPageClassRequestHandler {
    private final IPageProvider pageProvider;
    private final RedirectPolicy redirectPolicy;

    public RenderPageRequestHandler(IPageProvider pageProvider) {
        this(pageProvider, RedirectPolicy.AUTO_REDIRECT);
    }

    public RenderPageRequestHandler(IPageProvider pageProvider, RedirectPolicy redirectPolicy) {
        Args.notNull((Object)pageProvider, (String)"pageProvider");
        Args.notNull((Object)((Object)redirectPolicy), (String)"redirectPolicy");
        this.redirectPolicy = redirectPolicy;
        this.pageProvider = pageProvider;
    }

    public IPageProvider getPageProvider() {
        return this.pageProvider;
    }

    public RedirectPolicy getRedirectPolicy() {
        return this.redirectPolicy;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageProvider.getPageClass();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageProvider.getPageParameters();
    }

    public void detach(IRequestCycle requestCycle) {
        this.pageProvider.detach();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageProvider.getPageInstance();
    }

    public void respond(IRequestCycle requestCycle) {
        PageRenderer renderer = (PageRenderer)Application.get().getPageRendererProvider().get(this);
        renderer.respond((RequestCycle)requestCycle);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RedirectPolicy {
        ALWAYS_REDIRECT,
        NEVER_REDIRECT,
        AUTO_REDIRECT;

    }
}

