/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.handler.IPageProvider;
import org.apache.wicket.request.mapper.IPageSource;
import org.apache.wicket.request.mapper.StalePageException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageProvider
implements IPageProvider {
    private Integer renderCount;
    private IPageSource pageSource;
    private IRequestablePage pageInstance;
    private Class<? extends IRequestablePage> pageClass;
    private Integer pageId;
    private PageParameters pageParameters;

    public PageProvider(int pageId, Integer renderCount) {
        this.pageId = pageId;
        this.renderCount = renderCount;
    }

    public PageProvider(int pageId, Class<? extends IRequestablePage> pageClass, Integer renderCount) {
        this(pageId, pageClass, new PageParameters(), renderCount);
    }

    public PageProvider(int pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        this.pageId = pageId;
        this.setPageClass(pageClass);
        this.setPageParameters(pageParameters);
        this.renderCount = renderCount;
    }

    public PageProvider(Class<? extends IRequestablePage> pageClass, PageParameters pageParameters) {
        this.setPageClass(pageClass);
        if (pageParameters != null) {
            this.setPageParameters(pageParameters);
        }
    }

    public PageProvider(Class<? extends IRequestablePage> pageClass) {
        this(pageClass, null);
    }

    public PageProvider(IRequestablePage page) {
        Args.notNull((Object)page, (String)"page");
        this.pageInstance = page;
    }

    @Override
    public IRequestablePage getPageInstance() {
        if (this.pageInstance == null) {
            this.pageInstance = this.getPageInstance(this.pageId, this.pageClass, this.pageParameters, this.renderCount);
            if (this.pageInstance == null) {
                throw new PageExpiredException("Page expired.");
            }
            this.touchPageInstance(this.pageInstance);
        }
        return this.pageInstance;
    }

    private void touchPageInstance(IRequestablePage page) {
        if (Session.exists()) {
            Session.get().getPageManager().touchPage(page);
        }
    }

    @Override
    public PageParameters getPageParameters() {
        if (this.pageParameters != null) {
            return this.pageParameters;
        }
        if (this.pageInstance != null) {
            return this.pageInstance.getPageParameters();
        }
        return null;
    }

    @Override
    public boolean isNewPageInstance() {
        return this.pageInstance == null && this.pageId == null;
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        if (this.pageClass != null) {
            return this.pageClass;
        }
        return this.getPageInstance().getClass();
    }

    protected IPageSource getPageSource() {
        if (this.pageSource != null) {
            return this.pageSource;
        }
        if (Application.exists()) {
            return Application.get().getMapperContext();
        }
        throw new IllegalStateException("No application is bound to current thread. Call setPageSource() to manually assign pageSource to this provider.");
    }

    private IRequestablePage getPageInstance(Integer pageId, Class<? extends IRequestablePage> pageClass, PageParameters pageParameters, Integer renderCount) {
        IRequestablePage page = null;
        boolean freshCreated = false;
        if (pageId != null) {
            page = this.getPageSource().getPageInstance(pageId);
            if (page != null && pageClass != null && !page.getClass().equals(pageClass)) {
                page = null;
            } else if (page != null && pageParameters != null) {
                page.getPageParameters().overwriteWith(pageParameters);
            }
        }
        if (page == null && pageClass != null) {
            page = this.getPageSource().newPageInstance(pageClass, pageParameters);
            freshCreated = true;
        }
        if (page != null && !freshCreated && renderCount != null && page.getRenderCount() != renderCount.intValue()) {
            throw new StalePageException(page);
        }
        return page;
    }

    @Override
    public void detach() {
        if (this.pageInstance != null) {
            this.pageInstance.detach();
        }
    }

    public void setPageSource(IPageSource pageSource) {
        this.pageSource = pageSource;
    }

    private void setPageClass(Class<? extends IRequestablePage> pageClass) {
        Args.notNull(pageClass, (String)"pageClass");
        this.pageClass = pageClass;
    }

    private void setPageParameters(PageParameters pageParameters) {
        this.pageParameters = pageParameters;
    }

    public Integer getPageId() {
        return this.pageId;
    }
}

