/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler;

import org.apache.wicket.RequestListenerInterface;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.handler.IComponentRequestHandler;
import org.apache.wicket.request.handler.IPageAndComponentProvider;
import org.apache.wicket.request.handler.IPageRequestHandler;
import org.apache.wicket.request.handler.PageAndComponentProvider;
import org.apache.wicket.request.handler.PageProvider;
import org.apache.wicket.request.handler.RenderPageRequestHandler;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.lang.Args;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerInterfaceRequestHandler
implements IPageRequestHandler,
IComponentRequestHandler {
    private final IPageAndComponentProvider pageComponentProvider;
    private final RequestListenerInterface listenerInterface;
    private final Integer behaviorId;

    public ListenerInterfaceRequestHandler(IPageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface, Integer behaviorIndex) {
        Args.notNull((Object)pageComponentProvider, (String)"pageComponentProvider");
        Args.notNull((Object)listenerInterface, (String)"listenerInterface");
        this.pageComponentProvider = pageComponentProvider;
        this.listenerInterface = listenerInterface;
        this.behaviorId = behaviorIndex;
    }

    public ListenerInterfaceRequestHandler(PageAndComponentProvider pageComponentProvider, RequestListenerInterface listenerInterface) {
        this(pageComponentProvider, listenerInterface, null);
    }

    @Override
    public IRequestableComponent getComponent() {
        return this.pageComponentProvider.getComponent();
    }

    @Override
    public IRequestablePage getPage() {
        return this.pageComponentProvider.getPageInstance();
    }

    @Override
    public Class<? extends IRequestablePage> getPageClass() {
        return this.pageComponentProvider.getPageClass();
    }

    @Override
    public PageParameters getPageParameters() {
        return this.pageComponentProvider.getPageParameters();
    }

    public void detach(IRequestCycle requestCycle) {
        this.pageComponentProvider.detach();
    }

    public RequestListenerInterface getListenerInterface() {
        return this.listenerInterface;
    }

    public Integer getBehaviorIndex() {
        return this.behaviorId;
    }

    public void respond(IRequestCycle requestCycle) {
        IRequestablePage page = this.getPage();
        if (this.getComponent().getPage() == page) {
            boolean isAjax = ((WebRequest)requestCycle.getRequest()).isAjax();
            if (!isAjax && this.listenerInterface.isRenderPageAfterInvocation()) {
                RenderPageRequestHandler.RedirectPolicy policy = page.isPageStateless() ? RenderPageRequestHandler.RedirectPolicy.NEVER_REDIRECT : RenderPageRequestHandler.RedirectPolicy.AUTO_REDIRECT;
                requestCycle.scheduleRequestHandlerAfterCurrent((IRequestHandler)new RenderPageRequestHandler(new PageProvider(page), policy));
            }
        } else {
            throw new WicketRuntimeException("Component " + this.getComponent() + " has been removed from page.");
        }
        this.invokeListener();
    }

    private void invokeListener() {
        if (this.getBehaviorIndex() == null) {
            this.listenerInterface.invoke(this.getComponent());
        } else {
            try {
                Behavior behavior = this.getComponent().getBehaviorById(this.behaviorId);
                this.listenerInterface.invoke(this.getComponent(), behavior);
            }
            catch (IndexOutOfBoundsException e) {
                throw new WicketRuntimeException("Couldn't find component behavior.", e);
            }
        }
    }
}

