/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.cycle;

import java.util.ArrayList;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.listener.ListenerCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCycleListenerCollection
extends ListenerCollection<IRequestCycleListener>
implements IRequestCycleListener {
    private static final Logger logger = LoggerFactory.getLogger(RequestCycleListenerCollection.class);
    private static final long serialVersionUID = 1L;

    @Override
    public void onBeginRequest(final RequestCycle cycle) {
        this.notify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                listener.onBeginRequest(cycle);
            }
        });
    }

    @Override
    public void onEndRequest(final RequestCycle cycle) {
        this.reversedNotify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                listener.onEndRequest(cycle);
            }
        });
    }

    @Override
    public void onDetach(final RequestCycle cycle) {
        this.reversedNotify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                try {
                    listener.onDetach(cycle);
                }
                catch (Exception e) {
                    logger.error("Error detaching request cycle listener: " + listener, (Throwable)e);
                }
            }
        });
    }

    @Override
    public IRequestHandler onException(final RequestCycle cycle, final Exception ex) {
        final ArrayList handlers = new ArrayList();
        this.notify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                IRequestHandler handler = listener.onException(cycle, ex);
                if (handler != null) {
                    handlers.add(handler);
                }
            }
        });
        if (handlers.isEmpty()) {
            return null;
        }
        if (handlers.size() > 1) {
            logger.debug("{} exception handlers available for exception {}, using the first handler", (Object)handlers.size(), (Object)ex);
        }
        return (IRequestHandler)handlers.get(0);
    }

    @Override
    public void onRequestHandlerResolved(final RequestCycle cycle, final IRequestHandler handler) {
        this.notify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                listener.onRequestHandlerResolved(cycle, handler);
            }
        });
    }

    @Override
    public void onExceptionRequestHandlerResolved(final RequestCycle cycle, final IRequestHandler handler, final Exception exception) {
        this.notify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                listener.onExceptionRequestHandlerResolved(cycle, handler, exception);
            }
        });
    }

    @Override
    public void onRequestHandlerScheduled(final RequestCycle cycle, final IRequestHandler handler) {
        this.notify((ListenerCollection.INotifier)new ListenerCollection.INotifier<IRequestCycleListener>(){

            public void notify(IRequestCycleListener listener) {
                listener.onRequestHandlerScheduled(cycle, handler);
            }
        });
    }
}

