/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.Protocol;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

class SwitchProtocolRequestHandler
implements IRequestHandlerDelegate {
    private final Protocol protocol;
    private final IRequestHandler handler;
    private final HttpsConfig httpsConfig;

    SwitchProtocolRequestHandler(Protocol protocol, HttpsConfig httpsConfig) {
        this(protocol, null, httpsConfig);
    }

    SwitchProtocolRequestHandler(Protocol protocol, IRequestHandler handler, HttpsConfig httpsConfig) {
        Args.notNull((Object)((Object)protocol), (String)"protocol");
        Args.notNull((Object)httpsConfig, (String)"httpsConfig");
        if (protocol == Protocol.PRESERVE_CURRENT) {
            throw new IllegalArgumentException("Argument 'protocol' may not have value '" + Protocol.PRESERVE_CURRENT.toString() + "'.");
        }
        this.protocol = protocol;
        this.handler = handler;
        this.httpsConfig = httpsConfig;
    }

    protected String getUrl(String protocol, Integer port, HttpServletRequest request) {
        StringBuilder result = new StringBuilder();
        result.append(protocol);
        result.append("://");
        result.append(request.getServerName());
        if (port != null) {
            result.append(":");
            result.append(port);
        }
        result.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            result.append("?");
            result.append(request.getQueryString());
        }
        return result.toString();
    }

    public void respond(IRequestCycle requestCycle) {
        WebRequest webRequest = (WebRequest)requestCycle.getRequest();
        HttpServletRequest request = (HttpServletRequest)webRequest.getContainerRequest();
        Integer port = null;
        if (this.protocol == Protocol.HTTP) {
            if (this.httpsConfig.getHttpPort() != 80) {
                port = this.httpsConfig.getHttpPort();
            }
        } else if (this.protocol == Protocol.HTTPS && this.httpsConfig.getHttpsPort() != 443) {
            port = this.httpsConfig.getHttpsPort();
        }
        String url = this.handler == null ? this.getUrl(this.protocol.toString().toLowerCase(), port, request) : ((RequestCycle)requestCycle).mapUrlFor(this.handler).toString();
        WebResponse response = (WebResponse)requestCycle.getResponse();
        response.sendRedirect(url);
    }

    public static IRequestHandler requireProtocol(Protocol protocol, HttpsConfig httpsConfig) {
        return SwitchProtocolRequestHandler.requireProtocol(protocol, null, httpsConfig);
    }

    public static IRequestHandler requireProtocol(Protocol protocol, IRequestHandler handler, HttpsConfig httpsConfig) {
        RequestCycle requestCycle = RequestCycle.get();
        WebRequest webRequest = (WebRequest)requestCycle.getRequest();
        HttpServletRequest request = (HttpServletRequest)webRequest.getContainerRequest();
        if (protocol == null || protocol == Protocol.PRESERVE_CURRENT || request.getScheme().equals(protocol.toString().toLowerCase())) {
            return null;
        }
        return new SwitchProtocolRequestHandler(protocol, handler, httpsConfig);
    }

    public void detach(IRequestCycle requestCycle) {
    }

    public IRequestHandler getDelegateHandler() {
        return this.handler;
    }
}

