/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.UploadInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.upload.DiskFileItemFactory;
import org.apache.wicket.util.upload.FileItem;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.upload.RequestContext;
import org.apache.wicket.util.upload.ServletFileUpload;
import org.apache.wicket.util.upload.ServletRequestContext;
import org.apache.wicket.util.value.ValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartServletWebRequestImpl
extends MultipartServletWebRequest {
    private final Map<String, List<FileItem>> files = new HashMap<String, List<FileItem>>();
    private final ValueMap parameters = new ValueMap();
    private int bytesUploaded;
    private int totalBytes;
    private static final String SESSION_KEY = MultipartServletWebRequestImpl.class.getName();

    public MultipartServletWebRequestImpl(HttpServletRequest request, String filterPrefix, Bytes maxSize) throws FileUploadException {
        this(request, filterPrefix, maxSize, (FileItemFactory)new DiskFileItemFactory(Application.get().getResourceSettings().getFileUploadCleaner()));
    }

    public MultipartServletWebRequestImpl(HttpServletRequest request, String filterPrefix, Bytes maxSize, FileItemFactory factory) throws FileUploadException {
        super(request, filterPrefix);
        List items;
        if (maxSize == null) {
            throw new IllegalArgumentException("argument maxSize must be not null");
        }
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) {
            throw new IllegalStateException("ServletRequest does not contain multipart content. One possible solution is to explicitly call Form.setMultipart(true), Wicket tries its best to auto-detect multipart forms but there are certain situation where it cannot.");
        }
        ServletFileUpload upload = new ServletFileUpload(factory);
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        }
        if (encoding != null) {
            upload.setHeaderEncoding(encoding);
        }
        upload.setSizeMax(maxSize.bytes());
        if (this.wantUploadProgressUpdates()) {
            ServletRequestContext ctx = new ServletRequestContext(request){

                public InputStream getInputStream() throws IOException {
                    return new CountingInputStream(super.getInputStream());
                }
            };
            this.totalBytes = request.getContentLength();
            this.onUploadStarted(this.totalBytes);
            items = upload.parseRequest((RequestContext)ctx);
            this.onUploadCompleted();
        } else {
            items = upload.parseRequest(request);
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                String value;
                if (encoding != null) {
                    try {
                        value = item.getString(encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new WicketRuntimeException(e);
                    }
                } else {
                    value = item.getString();
                }
                this.addParameter(item.getFieldName(), value);
                continue;
            }
            List<FileItem> fileItems = this.files.get(item.getFieldName());
            if (fileItems == null) {
                fileItems = new ArrayList<FileItem>();
                this.files.put(item.getFieldName(), fileItems);
            }
            fileItems.add(item);
        }
    }

    private void addParameter(String name, String value) {
        String[] currVal = (String[])this.parameters.get((Object)name);
        String[] newVal = null;
        if (currVal != null) {
            newVal = new String[currVal.length + 1];
            System.arraycopy(currVal, 0, newVal, 0, currVal.length);
            newVal[currVal.length] = value;
        } else {
            newVal = new String[]{value};
        }
        this.parameters.put(name, (Object)newVal);
    }

    @Override
    public Map<String, List<FileItem>> getFiles() {
        return this.files;
    }

    @Override
    public List<FileItem> getFile(String fieldName) {
        return this.files.get(fieldName);
    }

    @Override
    protected Map<String, List<StringValue>> generatePostParameters() {
        HashMap<String, List<StringValue>> res = new HashMap<String, List<StringValue>>();
        for (String key : this.parameters.keySet()) {
            String[] val = (String[])this.parameters.get((Object)key);
            if (val == null || val.length <= 0) continue;
            ArrayList<StringValue> items = new ArrayList<StringValue>();
            for (String s : val) {
                items.add(StringValue.valueOf((String)s));
            }
            res.put(key, items);
        }
        return res;
    }

    protected boolean wantUploadProgressUpdates() {
        return Application.get().getApplicationSettings().isUploadProgressUpdatesEnabled();
    }

    protected void onUploadStarted(int totalBytes) {
        UploadInfo info = new UploadInfo(totalBytes);
        MultipartServletWebRequestImpl.setUploadInfo(this.getContainerRequest(), info);
    }

    protected void onUploadUpdate(int bytesUploaded, int total) {
        HttpServletRequest request = this.getContainerRequest();
        UploadInfo info = MultipartServletWebRequestImpl.getUploadInfo(request);
        if (info == null) {
            throw new IllegalStateException("could not find UploadInfo object in session which should have been set when uploaded started");
        }
        info.setBytesUploaded(bytesUploaded);
        MultipartServletWebRequestImpl.setUploadInfo(request, info);
    }

    protected void onUploadCompleted() {
        MultipartServletWebRequestImpl.clearUploadInfo(this.getContainerRequest());
    }

    @Override
    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize) throws FileUploadException {
        return this;
    }

    @Override
    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, FileItemFactory factory) throws FileUploadException {
        return this;
    }

    public static UploadInfo getUploadInfo(HttpServletRequest req) {
        Args.notNull((Object)req, (String)"req");
        return (UploadInfo)req.getSession().getAttribute(SESSION_KEY);
    }

    public static void setUploadInfo(HttpServletRequest req, UploadInfo uploadInfo) {
        Args.notNull((Object)req, (String)"req");
        Args.notNull((Object)uploadInfo, (String)"uploadInfo");
        req.getSession().setAttribute(SESSION_KEY, (Object)uploadInfo);
    }

    public static void clearUploadInfo(HttpServletRequest req) {
        Args.notNull((Object)req, (String)"req");
        req.getSession().removeAttribute(SESSION_KEY);
    }

    private class CountingInputStream
    extends InputStream {
        private final InputStream in;

        public CountingInputStream(InputStream in) {
            this.in = in;
        }

        public int read() throws IOException {
            int read = this.in.read();
            MultipartServletWebRequestImpl.this.bytesUploaded += read < 0 ? 0 : 1;
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }

        public int read(byte[] b) throws IOException {
            int read = this.in.read(b);
            MultipartServletWebRequestImpl.this.bytesUploaded += read < 0 ? 0 : read;
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            MultipartServletWebRequestImpl.this.bytesUploaded += read < 0 ? 0 : read;
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }
    }
}

