/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum UserAgent {
    MOZILLA("Opera,AppleWebKit,Konqueror", Arrays.asList("Mozilla", "Gecko")),
    FIREFOX("Opera,AppleWebKit,Konqueror", Arrays.asList("Mozilla", "Gecko", "Firefox")),
    INTERNET_EXPLORER("Opera", Arrays.asList("Mozilla", "MSIE", "Windows"), Arrays.asList("Mozilla", "MSIE", "Trident"), Arrays.asList("Mozilla", "MSIE", "Mac_PowerPC")),
    OPERA(Arrays.asList("Opera")),
    CHROME(Arrays.asList("Mozilla", "Chrome", "AppleWebKit", "Safari")),
    SAFARI("Chrome", Arrays.asList("Mozilla", "AppleWebKit", "Safari")),
    KONQUEROR(Arrays.asList("Konqueror"));

    private final String[] notAllowedList;
    private final List<String>[] detectionStrings;

    private UserAgent(String notAllowed, List<String> ... detectionStrings) {
        this.notAllowedList = Strings.split((String)notAllowed, (char)',');
        this.detectionStrings = detectionStrings;
    }

    private UserAgent(List<String> ... detectionStrings) {
        this((String)null, detectionStrings);
    }

    public boolean matches(String userAgent) {
        if (this.notAllowedList != null) {
            for (String value : this.notAllowedList) {
                if (!userAgent.contains(value)) continue;
                return false;
            }
        }
        for (List<String> detectionGroup : this.detectionStrings) {
            boolean groupPassed = true;
            Iterator i$ = detectionGroup.iterator();
            while (i$.hasNext()) {
                String detectionString = (String)i$.next();
                if (userAgent.contains(detectionString)) continue;
                groupPassed = false;
                break;
            }
            if (!groupPassed) continue;
            return true;
        }
        return false;
    }
}

